% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_export_image}
\alias{ec2_export_image}
\title{Export Image}
\usage{
ec2_export_image(
  DiskImageFormat,
  ImageId,
  S3ExportLocation,
  ClientToken = NULL,
  Description = NULL,
  DryRun = NULL,
  RoleName = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DiskImageFormat}{String. The disk image format.}

\item{ImageId}{String. The ID of the image.}

\item{S3ExportLocation}{Object. Information about the destination Amazon S3 bucket.}

\item{ClientToken}{String. Token to enable idempotency for export image requests.[optional]}

\item{Description}{String. A description of the image being exported. The maximum length is 255 characters.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{RoleName}{String. The name of the role that grants VM Import/Export permission to export images to your Amazon S3 bucket....[optional]}

\item{TagSpecification}{List. The tags to apply to the export image task during creation.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Exports an Amazon Machine Image (AMI) to a
VM file. For more information, see \href{https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport_image.html}{Exporting a VM Directory from an Amazon Machine Image (AMI)}
in the \emph{VM Import/Export User Guide}.
}
\section{DiskImageFormat}{

The disk image
format.
}

\section{ImageId}{

The ID of the
image.
}

\section{S3ExportLocation}{

Information about the destination Amazon S3
bucket. The bucket must exist and grant WRITE and READ_ACP permissions
to the AWS account
vm-import-export\@amazon.com.
}

\section{ClientToken}{

Token to enable
idempotency for export image requests.
}

\section{Description}{

A description
of the image being exported. The maximum length is 255
characters.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{RoleName}{

The name of the role that
grants VM Import/Export permission to export images to your Amazon S3
bucket. If this parameter is not specified, the default role is named
\'vmimport\'.
}

\section{TagSpecification}{

The tags to apply to the export image
task during creation.
}

