% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_purchase_reserved_instances_offering}
\alias{ec2_purchase_reserved_instances_offering}
\title{Purchase Reserved Instances Offering}
\usage{
ec2_purchase_reserved_instances_offering(
  InstanceCount,
  ReservedInstancesOfferingId,
  DryRun = NULL,
  LimitPrice = NULL,
  PurchaseTime = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InstanceCount}{Integer. The number of Reserved Instances to purchase.}

\item{ReservedInstancesOfferingId}{String. The ID of the Reserved Instance offering to purchase.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{LimitPrice}{Object. Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the...[optional]}

\item{PurchaseTime}{String. The time at which to purchase the Reserved Instance, in UTC format (for example, \emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z)....[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Purchase Reserved Instances Offering
}
\section{InstanceCount}{

The number of
Reserved Instances to purchase.
}

\section{ReservedInstancesOfferingId}{

The ID of the
Reserved Instance offering to purchase.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{LimitPrice}{

Specified
for Reserved Instance Marketplace offerings to limit the total order and
ensure that the Reserved Instances are not purchased at unexpected
prices.
}

\section{PurchaseTime}{

The time at which to purchase the Reserved
Instance, in UTC format (for example,
\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z).
}

