% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_traffic_mirror_session}
\alias{ec2_modify_traffic_mirror_session}
\title{Modify Traffic Mirror Session}
\usage{
ec2_modify_traffic_mirror_session(
  TrafficMirrorSessionId,
  TrafficMirrorTargetId = NULL,
  TrafficMirrorFilterId = NULL,
  PacketLength = NULL,
  SessionNumber = NULL,
  VirtualNetworkId = NULL,
  Description = NULL,
  RemoveField = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{TrafficMirrorSessionId}{Character. The ID of the Traffic Mirror session.}

\item{TrafficMirrorTargetId}{Character. The Traffic Mirror target.[optional]}

\item{TrafficMirrorFilterId}{Character. The ID of the Traffic Mirror filter.[optional]}

\item{PacketLength}{Integer. The number of bytes in each packet to mirror.[optional]}

\item{SessionNumber}{Integer.   The session number determines the order in which sessions are evaluated when an interface is used...[optional]}

\item{VirtualNetworkId}{Integer. The virtual network ID of the Traffic Mirror session.[optional]}

\item{Description}{Character. The description to assign to the Traffic Mirror session.[optional]}

\item{RemoveField}{List.   The properties that you want to remove from the Traffic Mirror session.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modifies a Traffic Mirror
session.
}
\section{TrafficMirrorSessionId}{

The ID of the Traffic
Mirror session.
}

\section{TrafficMirrorTargetId}{

The Traffic Mirror target. The
target must be in the same VPC as the source, or have a VPC peering
connection with the source.
}

\section{TrafficMirrorFilterId}{

The ID of the Traffic
Mirror filter.
}

\section{PacketLength}{

The number of bytes in each packet to
mirror. These are bytes after the VXLAN header. To mirror a subset, set
this to the length (in bytes) to mirror. For example, if you set this
value to 100, then the first 100 bytes that meet the filter criteria are
copied to the target. Do not specify this parameter when you want to
mirror the entire packet.
}

\section{SessionNumber}{


The session number determines the order in which sessions are evaluated
when an interface is used by multiple sessions. The first session with a
matching filter is the one that mirrors the packets.

Valid values are 1-32766.
}

\section{VirtualNetworkId}{

The virtual network ID of the Traffic Mirror
session.
}

\section{Description}{

The description to assign to the Traffic
Mirror session.
}

\section{RemoveField}{


The properties that you want to remove from the Traffic Mirror session.

When you remove a property from a Traffic Mirror session, the property
is set to the default.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

