% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_report_instance_status}
\alias{ec2_report_instance_status}
\title{Report Instance Status}
\usage{
ec2_report_instance_status(
  InstanceId,
  ReasonCode,
  Status,
  Description = NULL,
  DryRun = NULL,
  EndTime = NULL,
  StartTime = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{InstanceId}{List. The instances.}

\item{ReasonCode}{List.   The reason codes that describe the health state of your instance.}

\item{Status}{Character. The status of all instances listed.}

\item{Description}{Character. Descriptive text about the health state of your instance.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{EndTime}{Character. The time at which the reported instance health state ended.[optional]}

\item{StartTime}{Character. The time at which the reported instance health state began.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Report Instance Status
}
\section{InstanceId}{

The
instances.
}

\section{ReasonCode}{


The reason codes that describe the health state of your instance.
\itemize{
\item \verb{instance-stuck-in-state}: My instance is stuck in a state.
\item \code{unresponsive}: My instance is unresponsive.
\item \code{not-accepting-credentials}: My instance is not accepting my
credentials.
\item \code{password-not-available}: A password is not available for my
instance.
\item \code{performance-network}: My instance is experiencing performance
problems that I believe are network related.
\item \code{performance-instance-store}: My instance is experiencing
performance problems that I believe are related to the instance
stores.
\item \code{performance-ebs-volume}: My instance is experiencing performance
problems that I believe are related to an EBS volume.
\item \code{performance-other}: My instance is experiencing performance
problems.
\item \code{other}: [explain using the description parameter]
}
}

\section{Status}{

The status of all instances
listed.
}

\section{Description}{

Descriptive text about the health state of
your instance.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{EndTime}{

The time at which the
reported instance health state ended.
}

\section{StartTime}{

The time at
which the reported instance health state began.
}

