% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pollyHTTP.R
\name{pollyHTTP}
\alias{pollyHTTP}
\title{Execute AWS Polly API Request}
\usage{
pollyHTTP(action, query = list(), body = NULL, verb = c("GET", "POST",
  "PUT", "DELETE"), version = "v1", raw_response = if (verb == "POST") TRUE
  else FALSE, region = Sys.getenv("AWS_DEFAULT_REGION"),
  key = Sys.getenv("AWS_ACCESS_KEY_ID"),
  secret = Sys.getenv("AWS_SECRET_ACCESS_KEY"),
  session_token = Sys.getenv("AWS_SESSION_TOKEN"), ...)
}
\arguments{
\item{action}{A character string specifying the API action to take}

\item{query}{An optional named list containing query string parameters and their character values.}

\item{body}{A request body}

\item{verb}{A character string specifying the HTTP verb to implement.}

\item{version}{A character string specifying the API version.}

\item{raw_response}{A logical indicating whether to return the raw response body.}

\item{region}{A character string containing an AWS region. If missing, the default \dQuote{us-east-1} is used.}

\item{key}{A character string containing an AWS Access Key ID. The default is pulled from environment variable \dQuote{AWS_ACCESS_KEY_ID}.}

\item{secret}{A character string containing an AWS Secret Access Key. The default is pulled from environment variable \dQuote{AWS_SECRET_ACCESS_KEY}.}

\item{session_token}{Optionally, a character string containing an AWS temporary Session Token. If missing, defaults to value stored in environment variable \dQuote{AWS_SESSION_TOKEN}.}

\item{...}{Additional arguments passed to \code{\link[httr]{GET}}.}
}
\value{
If successful, a named list. Otherwise, a data structure of class \dQuote{aws-error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
This is the workhorse function to execute calls to the Polly API.
}
\details{
This function constructs and signs an Polly API request and returns the results thereof, or relevant debugging information in the case of error.
}
\author{
Thomas J. Leeper
}

