% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_queues.R
\name{list_queues}
\alias{list_queues}
\alias{deadletter_queues}
\title{List queues}
\usage{
list_queues(starts_with = NULL, query = NULL, ...)
}
\arguments{
\item{starts_with}{An optional character string describing the beginning of the name of queues to retrieve.}

\item{query}{A list specifying additional query arguments to be passed to the \code{query} argument of \code{\link{sqsHTTP}}.}

\item{...}{Additional arguments passed to \code{\link{sqsHTTP}}.}
}
\value{
If successful, a character vector containing queue URLs. Otherwise,
a data structure of class \dQuote{aws_error} containing any error message(s)
from AWS and information about the request attempt.
}
\description{
List SQS queues
}
\details{
For \code{list_queues}, a list of all SQS queue associated with an AWS
account, or only those starting with a particular character string.

For \code{deadletter_queues}, a list of all SQS queues with a RedrivePolicy
queue attribute configured with a dead letter queue.
}
\examples{
\dontrun{
  # list current queues
  list_queues()
}
}
\references{
\href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_ListQueues.html}{ListQueues}
\href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_ListDeadLetterSourceQueues.html}{ListDeadLetterSourceQueues}
}
\author{
Thomas J. Leeper
}
