\encoding{UTF-8}
\name{monthStats}
\alias{monthStats}
\alias{ms}
\title{Calculation of monthly means}
\description{Calculates monthly means of wind speed.}
\usage{
monthStats(mast, set, digits=3, print=TRUE)
ms(mast, set, digits=3, print=TRUE)
}
\arguments{
  \item{mast}{Met mast object created by \code{\link{createMast}}.}
  \item{set}{Set used for calculation specified as set number or set name. If missing, the calculation is carried out for all datasets that contain average wind speed \code{v.avg}.}
  \item{digits}{Number of decimal places to be used for results as numeric value. Default is \code{3}.}
  \item{print}{If \code{TRUE}, results are printed directly.}
}
\details{
\code{monthStats} averages valid wind speed data for each month and year in the measurement period. Means strongly depend on the measurement period and the number of samples. One important requirement for a reliable wind assessment is a measurement period covering the full seasonal cycle of variations.  A typical bias is a measurement limited to winter months, which usually results in overestimated wind speeds.
}
\value{Returns a list of data frames (one for each dataset) containing monthly, annual and total means of wind speed.}
\references{
Brower, M., Marcus, M., Taylor, M., Bernadett, D., Filippelli, M., Beaucage, P., Hale, E., Elsholz, K., Doane, J., Eberhard, M., Tensen, J., Ryan, D. (2010) Wind Resource Assessment Handbook. http://www.awstruepower.com/wp-content/uploads/2012/01/10-30_wind-resource-handbook.pdf
}
\author{Christian Graul}
\seealso{\code{\link{createMast}}, \code{\link{plotMonthStats}}, \code{\link{printObject}}}
\examples{
\dontrun{
# load and prepare data
data(winddata)
set40 <- createSet(height=40, v.avg=winddata[,2])
set30 <- createSet(height=30, v.avg=winddata[,6])
set20 <- createSet(height=20, v.avg=winddata[,10])
ts <- formatTS(time.stamp=winddata[,1])
neubuerg <- createMast(time.stamp=ts, set40, set30, set20)
neubuerg <- clean(mast=neubuerg)

# calculate monthly means
neubuerg.stats <- monthStats(mast=neubuerg)

# calculate monthly means for one dataset
neubuerg.stats.2 <- monthStats(mast=neubuerg, set=1)
neubuerg.stats.2 <- monthStats(mast=neubuerg, set="set1")	# same as above

# change number of digits and hide results
monthStats(mast=neubuerg, digits=2)
monthStats(mast=neubuerg, print=FALSE)
}
}
\keyword{methods}
