% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tss2_dens.R
\name{tss_dens}
\alias{tss_dens}
\title{Second order bagging CV bandwidth selector for Parzen-Rosenblatt estimator}
\usage{
tss_dens(x, r, s, h0, h1, nb = 1000, ncores = 1)
}
\arguments{
\item{x}{Vector. Sample.}

\item{r}{Vector. The two subsample sizes.}

\item{s}{Positive integer. Number of subsamples.}

\item{h0}{Positive real number. Range over which to minimize, left bound.}

\item{h1}{Positive real number. Range over which to minimize, right bound.}

\item{nb}{Positive integer. Number of bins.}

\item{ncores}{Positive integer. Number of cores with which to parallelize the computations.}
}
\value{
Second order bagging CV bandwidth.
}
\description{
Second order bagging CV bandwidth selector for Parzen-Rosenblatt estimator
}
\details{
Second order bagging cross-validation bandwidth selector for the Parzen-Rosenblatt estimator.
}
\examples{
set.seed(1)
x <- rnorm(10^5)
tss_dens(x, 5000, 10, 0.01, 1, 1000, 2)

}
