% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labbe.R
\name{labbe}
\alias{labbe}
\title{L'Abbe plot for binary data}
\usage{
labbe(
  data,
  group = "group",
  plot_model = FALSE,
  labels = TRUE,
  shade_se = c("rr", "or", "none")
)
}
\arguments{
\item{data}{a data frame with binary data
(must have columns \code{a}, \code{c}, \code{b}/\code{n1}, \code{d}/\code{n2})}

\item{group}{a character string specifying group names (e.g. study names), used for labels;}

\item{plot_model}{if \code{TRUE}, then odds ratios and risk ratios \link{baggr} models are estimated (using default
settings) and their mean estimates of effects are plotted as lines}

\item{labels}{if \code{TRUE}, names from the \code{group} column are displayed}

\item{shade_se}{if \code{"none"}, nothing is plotted, if \code{"or"} or \code{"rr"}, a shaded area corresponding to
inverse of effect's (OR or RR) SE is added to each data point; the default is \code{"rr"}}
}
\value{
A \code{ggplot} object
}
\description{
This plot shows relationship between proportions of events in control and treatment groups in binary data.
}
\seealso{
\code{vignette("baggr_binary")} for an illustrative example
}
