// Generated by rstantools.  Do not edit by hand.

/*
    baggr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    baggr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with baggr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-1-g67504470
#include <stan/model/model_header.hpp>
namespace model_mutau_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 48, column 2 to column 34)",
                                                      " (in 'string', line 49, column 2 to column 53)",
                                                      " (in 'string', line 50, column 2 to column 48)",
                                                      " (in 'string', line 51, column 2 to column 37)",
                                                      " (in 'string', line 54, column 2 to column 41)",
                                                      " (in 'string', line 55, column 2 to column 37)",
                                                      " (in 'string', line 57, column 4 to column 24)",
                                                      " (in 'string', line 56, column 2 to line 57, column 24)",
                                                      " (in 'string', line 64, column 4 to column 55)",
                                                      " (in 'string', line 68, column 6 to column 74)",
                                                      " (in 'string', line 66, column 6 to column 58)",
                                                      " (in 'string', line 65, column 4 to line 68, column 74)",
                                                      " (in 'string', line 58, column 23 to line 69, column 3)",
                                                      " (in 'string', line 58, column 2 to line 69, column 3)",
                                                      " (in 'string', line 104, column 2 to column 25)",
                                                      " (in 'string', line 106, column 4 to column 17)",
                                                      " (in 'string', line 110, column 8 to line 111, column 78)",
                                                      " (in 'string', line 109, column 8 to line 111, column 78)",
                                                      " (in 'string', line 113, column 8 to line 114, column 62)",
                                                      " (in 'string', line 112, column 8 to line 114, column 62)",
                                                      " (in 'string', line 108, column 20 to line 115, column 7)",
                                                      " (in 'string', line 108, column 6 to line 115, column 7)",
                                                      " (in 'string', line 107, column 22 to line 116, column 5)",
                                                      " (in 'string', line 107, column 4 to line 116, column 5)",
                                                      " (in 'string', line 105, column 17 to line 117, column 3)",
                                                      " (in 'string', line 105, column 2 to line 117, column 3)",
                                                      " (in 'string', line 81, column 6 to column 77)",
                                                      " (in 'string', line 80, column 4 to line 81, column 77)",
                                                      " (in 'string', line 79, column 9 to line 82, column 3)",
                                                      " (in 'string', line 78, column 6 to column 72)",
                                                      " (in 'string', line 77, column 4 to line 78, column 72)",
                                                      " (in 'string', line 76, column 24 to line 79, column 3)",
                                                      " (in 'string', line 76, column 2 to line 82, column 3)",
                                                      " (in 'string', line 85, column 4 to column 37)",
                                                      " (in 'string', line 87, column 6 to column 70)",
                                                      " (in 'string', line 86, column 4 to line 87, column 70)",
                                                      " (in 'string', line 89, column 4 to column 55)",
                                                      " (in 'string', line 84, column 24 to line 90, column 3)",
                                                      " (in 'string', line 84, column 2 to line 90, column 3)",
                                                      " (in 'string', line 95, column 8 to column 68)",
                                                      " (in 'string', line 94, column 6 to line 95, column 68)",
                                                      " (in 'string', line 92, column 19 to line 96, column 5)",
                                                      " (in 'string', line 92, column 4 to line 96, column 5)",
                                                      " (in 'string', line 91, column 33 to line 97, column 3)",
                                                      " (in 'string', line 91, column 2 to line 97, column 3)",
                                                      " (in 'string', line 101, column 8 to column 61)",
                                                      " (in 'string', line 100, column 6 to line 101, column 61)",
                                                      " (in 'string', line 99, column 4 to line 101, column 61)",
                                                      " (in 'string', line 98, column 2 to line 101, column 61)",
                                                      " (in 'string', line 24, column 2 to column 17)",
                                                      " (in 'string', line 25, column 2 to column 17)",
                                                      " (in 'string', line 26, column 19 to column 20)",
                                                      " (in 'string', line 26, column 21 to column 22)",
                                                      " (in 'string', line 26, column 2 to column 24)",
                                                      " (in 'string', line 27, column 27 to column 28)",
                                                      " (in 'string', line 27, column 29 to column 30)",
                                                      " (in 'string', line 27, column 2 to column 32)",
                                                      " (in 'string', line 28, column 2 to column 19)",
                                                      " (in 'string', line 29, column 2 to column 31)",
                                                      " (in 'string', line 32, column 2 to column 26)",
                                                      " (in 'string', line 33, column 9 to column 10)",
                                                      " (in 'string', line 33, column 2 to column 33)",
                                                      " (in 'string', line 34, column 18 to column 19)",
                                                      " (in 'string', line 34, column 21 to column 22)",
                                                      " (in 'string', line 34, column 2 to column 46)",
                                                      " (in 'string', line 35, column 2 to column 24)",
                                                      " (in 'string', line 36, column 2 to column 30)",
                                                      " (in 'string', line 37, column 2 to column 25)",
                                                      " (in 'string', line 38, column 2 to column 26)",
                                                      " (in 'string', line 40, column 2 to column 22)",
                                                      " (in 'string', line 41, column 24 to column 25)",
                                                      " (in 'string', line 41, column 26 to column 32)",
                                                      " (in 'string', line 41, column 2 to column 34)",
                                                      " (in 'string', line 42, column 32 to column 33)",
                                                      " (in 'string', line 42, column 34 to column 40)",
                                                      " (in 'string', line 42, column 2 to column 42)",
                                                      " (in 'string', line 45, column 2 to column 43)",
                                                      " (in 'string', line 48, column 15 to column 32)",
                                                      " (in 'string', line 48, column 9 to column 10)",
                                                      " (in 'string', line 49, column 34 to column 51)",
                                                      " (in 'string', line 49, column 23 to column 24)",
                                                      " (in 'string', line 50, column 29 to column 46)",
                                                      " (in 'string', line 50, column 18 to column 19)",
                                                      " (in 'string', line 51, column 18 to column 35)",
                                                      " (in 'string', line 51, column 9 to column 10)",
                                                      " (in 'string', line 51, column 11 to column 12)",
                                                      " (in 'string', line 54, column 22 to column 39)",
                                                      " (in 'string', line 54, column 9 to column 10)",
                                                      " (in 'string', line 54, column 11 to column 12)",
                                                      " (in 'string', line 55, column 18 to column 35)",
                                                      " (in 'string', line 55, column 9 to column 10)",
                                                      " (in 'string', line 55, column 11 to column 12)",
                                                      " (in 'string', line 104, column 13 to column 23)",
                                                      " (in 'string', line 11, column 9 to column 66)",
                                                      " (in 'string', line 9, column 25 to column 73)",
                                                      " (in 'string', line 9, column 9 to line 11, column 66)",
                                                      " (in 'string', line 6, column 25 to column 70)",
                                                      " (in 'string', line 6, column 9 to line 11, column 66)",
                                                      " (in 'string', line 5, column 25 to column 70)",
                                                      " (in 'string', line 5, column 9 to line 11, column 66)",
                                                      " (in 'string', line 4, column 20 to column 66)",
                                                      " (in 'string', line 4, column 4 to line 11, column 66)",
                                                      " (in 'string', line 3, column 60 to line 12, column 3)",
                                                      " (in 'string', line 20, column 9 to column 66)",
                                                      " (in 'string', line 18, column 25 to column 73)",
                                                      " (in 'string', line 18, column 9 to line 20, column 66)",
                                                      " (in 'string', line 17, column 25 to column 70)",
                                                      " (in 'string', line 17, column 9 to line 20, column 66)",
                                                      " (in 'string', line 16, column 25 to column 70)",
                                                      " (in 'string', line 16, column 9 to line 20, column 66)",
                                                      " (in 'string', line 15, column 20 to column 66)",
                                                      " (in 'string', line 15, column 4 to line 20, column 66)",
                                                      " (in 'string', line 14, column 61 to line 21, column 3)"};
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<T0__,
stan::value_type_t<T2__>>
realprior_lpdf(const T0__& theta, const int& family, const T2__& pars_arg__,
               std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T2__>>;
  const auto& pars = to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 102;
    if (logical_eq(family, 0)) {
      current_statement__ = 101;
      return uniform_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
    } else {
      current_statement__ = 100;
      if (logical_eq(family, 1)) {
        current_statement__ = 99;
        return normal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
      } else {
        current_statement__ = 98;
        if (logical_eq(family, 2)) {
          current_statement__ = 97;
          return cauchy_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
        } else {
          current_statement__ = 96;
          if (logical_eq(family, 5)) {
            current_statement__ = 95;
            return lognormal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
          } else {
            current_statement__ = 94;
            return student_t_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)],
                     pars[(3 - 1)]);
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct realprior_lpdf_functor__ {
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<T0__,
stan::value_type_t<T2__>>
operator()(const T0__& theta, const int& family, const T2__& pars,
           std::ostream* pstream__)  const 
{
return realprior_lpdf<propto__>(theta, family, pars, pstream__);
}
};
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>
vecprior_lpdf(const T0__& theta_arg__, const int& family,
              const T2__& pars_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T2__>>;
  const auto& theta = to_ref(theta_arg__);
  const auto& pars = to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 112;
    if (logical_eq(family, 0)) {
      current_statement__ = 111;
      return uniform_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
    } else {
      current_statement__ = 110;
      if (logical_eq(family, 1)) {
        current_statement__ = 109;
        return normal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
      } else {
        current_statement__ = 108;
        if (logical_eq(family, 2)) {
          current_statement__ = 107;
          return cauchy_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
        } else {
          current_statement__ = 106;
          if (logical_eq(family, 5)) {
            current_statement__ = 105;
            return lognormal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
          } else {
            current_statement__ = 104;
            return student_t_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)],
                     pars[(3 - 1)]);
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct vecprior_lpdf_functor__ {
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>
operator()(const T0__& theta, const int& family, const T2__& pars,
           std::ostream* pstream__)  const 
{
return vecprior_lpdf<propto__>(theta, family, pars, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_mutau final : public model_base_crtp<model_mutau> {
private:
  int K;
  int P;
  std::vector<std::vector<double>> theta_hat_k;
  std::vector<std::vector<double>> se_theta_k;
  int pooling_type;
  int cumsum;
  int prior_hypermean_fam;
  Eigen::Matrix<double, -1, 1> prior_hypermean_mean;
  Eigen::Matrix<double, -1, -1> prior_hypermean_scale;
  int prior_hypersd_fam;
  Eigen::Matrix<double, -1, 1> prior_hypersd_val;
  int prior_hypercor_fam;
  double prior_hypercor_val;
  int K_test;
  std::vector<std::vector<double>> test_theta_hat_k;
  std::vector<std::vector<double>> test_se_theta_k;
  int K_pooled;
  int mu_1dim__;
  int L_Omega_1dim__;
  int hypersd_1dim__;
  int eta_1dim__;
  int theta_k_1dim__;
  int tau_1dim__;
  int logpd_1dim__;
 
public:
  ~model_mutau() { }
  
  inline std::string model_name() const final { return "model_mutau"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-1-g67504470", "stancflags = "};
  }
  
  
  model_mutau(stan::io::var_context& context__,
              unsigned int random_seed__ = 0,
              std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_mutau_namespace::model_mutau";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 50;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 50;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 50;
      current_statement__ = 50;
      check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 51;
      context__.validate_dims("data initialization","P","int",
          context__.to_vec());
      P = std::numeric_limits<int>::min();
      
      current_statement__ = 51;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 51;
      current_statement__ = 51;
      check_greater_or_equal(function__, "P", P, 2);
      current_statement__ = 52;
      validate_non_negative_index("theta_hat_k", "P", P);
      current_statement__ = 53;
      validate_non_negative_index("theta_hat_k", "K", K);
      current_statement__ = 54;
      context__.validate_dims("data initialization","theta_hat_k","double",
          context__.to_vec(P, K));
      theta_hat_k = std::vector<std::vector<double>>(P, std::vector<double>(K, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> theta_hat_k_flat__;
        current_statement__ = 54;
        assign(theta_hat_k_flat__, nil_index_list(),
          context__.vals_r("theta_hat_k"),
          "assigning variable theta_hat_k_flat__");
        current_statement__ = 54;
        pos__ = 1;
        current_statement__ = 54;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 54;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 54;
            assign(theta_hat_k,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              theta_hat_k_flat__[(pos__ - 1)],
              "assigning variable theta_hat_k");
            current_statement__ = 54;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 55;
      validate_non_negative_index("se_theta_k", "P", P);
      current_statement__ = 56;
      validate_non_negative_index("se_theta_k", "K", K);
      current_statement__ = 57;
      context__.validate_dims("data initialization","se_theta_k","double",
          context__.to_vec(P, K));
      se_theta_k = std::vector<std::vector<double>>(P, std::vector<double>(K, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> se_theta_k_flat__;
        current_statement__ = 57;
        assign(se_theta_k_flat__, nil_index_list(),
          context__.vals_r("se_theta_k"),
          "assigning variable se_theta_k_flat__");
        current_statement__ = 57;
        pos__ = 1;
        current_statement__ = 57;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 57;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 57;
            assign(se_theta_k,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              se_theta_k_flat__[(pos__ - 1)], "assigning variable se_theta_k");
            current_statement__ = 57;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 57;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 57;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 57;
          current_statement__ = 57;
          check_greater_or_equal(function__, "se_theta_k[sym1__, sym2__]",
                                 se_theta_k[(sym1__ - 1)][(sym2__ - 1)], 0);}
      }
      current_statement__ = 58;
      context__.validate_dims("data initialization","pooling_type","int",
          context__.to_vec());
      pooling_type = std::numeric_limits<int>::min();
      
      current_statement__ = 58;
      pooling_type = context__.vals_i("pooling_type")[(1 - 1)];
      current_statement__ = 59;
      context__.validate_dims("data initialization","cumsum","int",
          context__.to_vec());
      cumsum = std::numeric_limits<int>::min();
      
      current_statement__ = 59;
      cumsum = context__.vals_i("cumsum")[(1 - 1)];
      current_statement__ = 59;
      current_statement__ = 59;
      check_greater_or_equal(function__, "cumsum", cumsum, 0);
      current_statement__ = 59;
      current_statement__ = 59;
      check_less_or_equal(function__, "cumsum", cumsum, 1);
      current_statement__ = 60;
      context__.validate_dims("data initialization","prior_hypermean_fam",
          "int",context__.to_vec());
      prior_hypermean_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 60;
      prior_hypermean_fam = context__.vals_i("prior_hypermean_fam")[(1 - 1)];
      current_statement__ = 61;
      validate_non_negative_index("prior_hypermean_mean", "P", P);
      current_statement__ = 62;
      context__.validate_dims("data initialization","prior_hypermean_mean",
          "double",context__.to_vec(P));
      prior_hypermean_mean = Eigen::Matrix<double, -1, 1>(P);
      stan::math::fill(prior_hypermean_mean, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_hypermean_mean_flat__;
        current_statement__ = 62;
        assign(prior_hypermean_mean_flat__, nil_index_list(),
          context__.vals_r("prior_hypermean_mean"),
          "assigning variable prior_hypermean_mean_flat__");
        current_statement__ = 62;
        pos__ = 1;
        current_statement__ = 62;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 62;
          assign(prior_hypermean_mean,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_hypermean_mean_flat__[(pos__ - 1)],
            "assigning variable prior_hypermean_mean");
          current_statement__ = 62;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 63;
      validate_non_negative_index("prior_hypermean_scale", "P", P);
      current_statement__ = 64;
      validate_non_negative_index("prior_hypermean_scale", "P", P);
      current_statement__ = 65;
      context__.validate_dims("data initialization","prior_hypermean_scale",
          "double",context__.to_vec(P, P));
      prior_hypermean_scale = Eigen::Matrix<double, -1, -1>(P, P);
      stan::math::fill(prior_hypermean_scale, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_hypermean_scale_flat__;
        current_statement__ = 65;
        assign(prior_hypermean_scale_flat__, nil_index_list(),
          context__.vals_r("prior_hypermean_scale"),
          "assigning variable prior_hypermean_scale_flat__");
        current_statement__ = 65;
        pos__ = 1;
        current_statement__ = 65;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 65;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 65;
            assign(prior_hypermean_scale,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              prior_hypermean_scale_flat__[(pos__ - 1)],
              "assigning variable prior_hypermean_scale");
            current_statement__ = 65;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 65;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 65;
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          current_statement__ = 65;
          current_statement__ = 65;
          check_greater_or_equal(function__,
                                 "prior_hypermean_scale[sym1__, sym2__]",
                                 rvalue(prior_hypermean_scale,
                                   cons_list(index_uni(sym1__),
                                     cons_list(index_uni(sym2__),
                                       nil_index_list())),
                                   "prior_hypermean_scale"), 0);}}
      current_statement__ = 66;
      context__.validate_dims("data initialization","prior_hypersd_fam",
          "int",context__.to_vec());
      prior_hypersd_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 66;
      prior_hypersd_fam = context__.vals_i("prior_hypersd_fam")[(1 - 1)];
      current_statement__ = 67;
      context__.validate_dims("data initialization","prior_hypersd_val",
          "double",context__.to_vec(3));
      prior_hypersd_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_hypersd_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_hypersd_val_flat__;
        current_statement__ = 67;
        assign(prior_hypersd_val_flat__, nil_index_list(),
          context__.vals_r("prior_hypersd_val"),
          "assigning variable prior_hypersd_val_flat__");
        current_statement__ = 67;
        pos__ = 1;
        current_statement__ = 67;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 67;
          assign(prior_hypersd_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_hypersd_val_flat__[(pos__ - 1)],
            "assigning variable prior_hypersd_val");
          current_statement__ = 67;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 68;
      context__.validate_dims("data initialization","prior_hypercor_fam",
          "int",context__.to_vec());
      prior_hypercor_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 68;
      prior_hypercor_fam = context__.vals_i("prior_hypercor_fam")[(1 - 1)];
      current_statement__ = 69;
      context__.validate_dims("data initialization","prior_hypercor_val",
          "double",context__.to_vec());
      prior_hypercor_val = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 69;
      prior_hypercor_val = context__.vals_r("prior_hypercor_val")[(1 - 1)];
      current_statement__ = 70;
      context__.validate_dims("data initialization","K_test","int",
          context__.to_vec());
      K_test = std::numeric_limits<int>::min();
      
      current_statement__ = 70;
      K_test = context__.vals_i("K_test")[(1 - 1)];
      current_statement__ = 70;
      current_statement__ = 70;
      check_greater_or_equal(function__, "K_test", K_test, 0);
      current_statement__ = 71;
      validate_non_negative_index("test_theta_hat_k", "P", P);
      current_statement__ = 72;
      validate_non_negative_index("test_theta_hat_k", "K_test", K_test);
      current_statement__ = 73;
      context__.validate_dims("data initialization","test_theta_hat_k",
          "double",context__.to_vec(P, K_test));
      test_theta_hat_k = std::vector<std::vector<double>>(P, std::vector<double>(K_test, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> test_theta_hat_k_flat__;
        current_statement__ = 73;
        assign(test_theta_hat_k_flat__, nil_index_list(),
          context__.vals_r("test_theta_hat_k"),
          "assigning variable test_theta_hat_k_flat__");
        current_statement__ = 73;
        pos__ = 1;
        current_statement__ = 73;
        for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
          current_statement__ = 73;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 73;
            assign(test_theta_hat_k,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              test_theta_hat_k_flat__[(pos__ - 1)],
              "assigning variable test_theta_hat_k");
            current_statement__ = 73;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 74;
      validate_non_negative_index("test_se_theta_k", "P", P);
      current_statement__ = 75;
      validate_non_negative_index("test_se_theta_k", "K_test", K_test);
      current_statement__ = 76;
      context__.validate_dims("data initialization","test_se_theta_k",
          "double",context__.to_vec(P, K_test));
      test_se_theta_k = std::vector<std::vector<double>>(P, std::vector<double>(K_test, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> test_se_theta_k_flat__;
        current_statement__ = 76;
        assign(test_se_theta_k_flat__, nil_index_list(),
          context__.vals_r("test_se_theta_k"),
          "assigning variable test_se_theta_k_flat__");
        current_statement__ = 76;
        pos__ = 1;
        current_statement__ = 76;
        for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
          current_statement__ = 76;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 76;
            assign(test_se_theta_k,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              test_se_theta_k_flat__[(pos__ - 1)],
              "assigning variable test_se_theta_k");
            current_statement__ = 76;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 76;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 76;
        for (int sym2__ = 1; sym2__ <= K_test; ++sym2__) {
          current_statement__ = 76;
          current_statement__ = 76;
          check_greater_or_equal(function__,
                                 "test_se_theta_k[sym1__, sym2__]",
                                 test_se_theta_k[(sym1__ - 1)][(sym2__ - 1)],
                                 0);}}
      current_statement__ = 77;
      K_pooled = std::numeric_limits<int>::min();
      
      current_statement__ = 77;
      K_pooled = (logical_eq(pooling_type, 2) ? 0 : K);
      current_statement__ = 78;
      mu_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 78;
      mu_1dim__ = logical_neq(pooling_type, 0);
      current_statement__ = 78;
      validate_non_negative_index("mu", "pooling_type != 0", mu_1dim__);
      current_statement__ = 79;
      validate_non_negative_index("mu", "P", P);
      current_statement__ = 80;
      L_Omega_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 80;
      L_Omega_1dim__ = logical_eq(pooling_type, 1);
      current_statement__ = 80;
      validate_non_negative_index("L_Omega", "pooling_type == 1",
                                  L_Omega_1dim__);
      current_statement__ = 81;
      validate_non_negative_index("L_Omega", "P", P);
      current_statement__ = 81;
      validate_non_negative_index("L_Omega", "P", P);
      current_statement__ = 82;
      hypersd_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 82;
      hypersd_1dim__ = logical_eq(pooling_type, 1);
      current_statement__ = 82;
      validate_non_negative_index("hypersd", "pooling_type == 1",
                                  hypersd_1dim__);
      current_statement__ = 83;
      validate_non_negative_index("hypersd", "P", P);
      current_statement__ = 84;
      eta_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 84;
      eta_1dim__ = logical_neq(pooling_type, 2);
      current_statement__ = 84;
      validate_non_negative_index("eta", "pooling_type != 2", eta_1dim__);
      current_statement__ = 85;
      validate_non_negative_index("eta", "P", P);
      current_statement__ = 86;
      validate_non_negative_index("eta", "K", K);
      current_statement__ = 87;
      theta_k_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 87;
      theta_k_1dim__ = logical_neq(pooling_type, 2);
      current_statement__ = 87;
      validate_non_negative_index("theta_k", "pooling_type != 2",
                                  theta_k_1dim__);
      current_statement__ = 88;
      validate_non_negative_index("theta_k", "P", P);
      current_statement__ = 89;
      validate_non_negative_index("theta_k", "K", K);
      current_statement__ = 90;
      tau_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 90;
      tau_1dim__ = logical_eq(pooling_type, 1);
      current_statement__ = 90;
      validate_non_negative_index("tau", "pooling_type == 1", tau_1dim__);
      current_statement__ = 91;
      validate_non_negative_index("tau", "P", P);
      current_statement__ = 92;
      validate_non_negative_index("tau", "P", P);
      current_statement__ = 93;
      logpd_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 93;
      logpd_1dim__ = logical_gt(K_test, 0);
      current_statement__ = 93;
      validate_non_negative_index("logpd", "K_test > 0", logpd_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += mu_1dim__ * P;
      num_params_r__ += L_Omega_1dim__ * ((P * (P - 1)) / 2);
      num_params_r__ += hypersd_1dim__ * P;
      num_params_r__ += eta_1dim__ * P * K;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_mutau_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(mu_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(P));
      stan::math::fill(mu, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(P), "assigning variable mu");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> L_Omega;
      L_Omega = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(L_Omega_1dim__, Eigen::Matrix<local_scalar_t__, -1, -1>(P, P));
      stan::math::fill(L_Omega, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> L_Omega_in__;
      L_Omega_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(L_Omega_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(
        ((P * (P - 1)) / 2)));
      stan::math::fill(L_Omega_in__, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(L_Omega_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(((P * (P - 1)) / 2)), "assigning variable L_Omega_in__");
      }
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(L_Omega, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cholesky_corr_constrain(L_Omega_in__[(sym1__ - 1)],
              P, lp__), "assigning variable L_Omega");
        } else {
          current_statement__ = 2;
          assign(L_Omega, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cholesky_corr_constrain(L_Omega_in__[(sym1__ - 1)], P),
            "assigning variable L_Omega");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> hypersd;
      hypersd = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(hypersd_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(P));
      stan::math::fill(hypersd, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(hypersd, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(P), "assigning variable hypersd");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          current_statement__ = 3;
          if (jacobian__) {
            current_statement__ = 3;
            assign(hypersd,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(hypersd[(sym1__ - 1)][(sym2__ - 1)],
                0, lp__), "assigning variable hypersd");
          } else {
            current_statement__ = 3;
            assign(hypersd,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(hypersd[(sym1__ - 1)][(sym2__ - 1)], 0),
              "assigning variable hypersd");
          }}}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> eta;
      eta = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(eta_1dim__, Eigen::Matrix<local_scalar_t__, -1, -1>(P, K));
      stan::math::fill(eta, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= eta_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(eta, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(P, K), "assigning variable eta");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> theta_k;
      theta_k = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(theta_k_1dim__, Eigen::Matrix<local_scalar_t__, -1, -1>(P, K));
      stan::math::fill(theta_k, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> tau;
      tau = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(tau_1dim__, Eigen::Matrix<local_scalar_t__, -1, -1>(P, P));
      stan::math::fill(tau, DUMMY_VAR__);
      
      current_statement__ = 8;
      if (logical_eq(pooling_type, 0)) {
        current_statement__ = 7;
        assign(theta_k, cons_list(index_uni(1), nil_index_list()),
          eta[(1 - 1)], "assigning variable theta_k");
      } 
      current_statement__ = 14;
      if (logical_eq(pooling_type, 1)) {
        current_statement__ = 9;
        assign(tau, cons_list(index_uni(1), nil_index_list()),
          diag_pre_multiply(hypersd[(1 - 1)], L_Omega[(1 - 1)]),
          "assigning variable tau");
        current_statement__ = 12;
        if (logical_eq(cumsum, 1)) {
          current_statement__ = 11;
          assign(theta_k, cons_list(index_uni(1), nil_index_list()),
            add(rep_matrix(mu[(1 - 1)], K),
              multiply(tau[(1 - 1)], eta[(1 - 1)])),
            "assigning variable theta_k");
        } else {
          current_statement__ = 10;
          assign(theta_k, cons_list(index_uni(1), nil_index_list()),
            add(rep_matrix(cumulative_sum(mu[(1 - 1)]), K),
              multiply(tau[(1 - 1)], eta[(1 - 1)])),
            "assigning variable theta_k");
        }
      } 
      {
        current_statement__ = 33;
        if (logical_neq(pooling_type, 0)) {
          current_statement__ = 31;
          if (logical_eq(prior_hypermean_fam, 3)) {
            current_statement__ = 30;
            lp_accum__.add(
              multi_normal_lpdf<propto__>(mu[(1 - 1)], prior_hypermean_mean,
                prior_hypermean_scale));
          } 
        } else {
          current_statement__ = 28;
          for (int k = 1; k <= K; ++k) {
            current_statement__ = 27;
            lp_accum__.add(
              multi_normal_lpdf<propto__>(
                rvalue(eta[(1 - 1)],
                  cons_list(index_omni(),
                    cons_list(index_uni(k), nil_index_list())), "eta[1]"),
                prior_hypermean_mean, prior_hypermean_scale));}
        }
        current_statement__ = 39;
        if (logical_eq(pooling_type, 1)) {
          current_statement__ = 34;
          lp_accum__.add(std_normal_lpdf<propto__>(to_vector(eta[(1 - 1)])));
          current_statement__ = 36;
          for (int p = 1; p <= P; ++p) {
            current_statement__ = 35;
            lp_accum__.add(
              realprior_lpdf<propto__>(hypersd[(1 - 1)][(p - 1)],
                prior_hypersd_fam, prior_hypersd_val, pstream__));}
          current_statement__ = 37;
          lp_accum__.add(
            lkj_corr_cholesky_lpdf<propto__>(L_Omega[(1 - 1)],
              prior_hypercor_val));
        } 
        current_statement__ = 45;
        if ((primitive_value(logical_eq(pooling_type, 1)) && primitive_value(
            logical_gt(K, 0)))) {
          current_statement__ = 43;
          for (int k = 1; k <= K; ++k) {
            current_statement__ = 41;
            for (int p = 1; p <= P; ++p) {
              current_statement__ = 40;
              lp_accum__.add(
                normal_lpdf<propto__>(theta_hat_k[(p - 1)][(k - 1)],
                  rvalue(theta_k[(1 - 1)],
                    cons_list(index_uni(p),
                      cons_list(index_uni(k), nil_index_list())),
                    "theta_k[1]"), se_theta_k[(p - 1)][(k - 1)]));}}
        } 
        current_statement__ = 49;
        if ((primitive_value(logical_eq(pooling_type, 2)) && primitive_value(
            logical_gt(K, 0)))) {
          current_statement__ = 48;
          for (int k = 1; k <= K; ++k) {
            current_statement__ = 47;
            for (int p = 1; p <= P; ++p) {
              current_statement__ = 46;
              lp_accum__.add(
                normal_lpdf<propto__>(theta_hat_k[(p - 1)][(k - 1)],
                  mu[(1 - 1)][(p - 1)], se_theta_k[(p - 1)][(k - 1)]));}}
        } 
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_mutau_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(mu_1dim__, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(P), "assigning variable mu");}
      std::vector<Eigen::Matrix<double, -1, -1>> L_Omega;
      L_Omega = std::vector<Eigen::Matrix<double, -1, -1>>(L_Omega_1dim__, Eigen::Matrix<double, -1, -1>(P, P));
      stan::math::fill(L_Omega, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> L_Omega_in__;
      L_Omega_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(L_Omega_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(
        ((P * (P - 1)) / 2)));
      stan::math::fill(L_Omega_in__, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(L_Omega_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(((P * (P - 1)) / 2)), "assigning variable L_Omega_in__");
      }
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(L_Omega, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cholesky_corr_constrain(L_Omega_in__[(sym1__ - 1)], P),
          "assigning variable L_Omega");}
      std::vector<Eigen::Matrix<double, -1, 1>> hypersd;
      hypersd = std::vector<Eigen::Matrix<double, -1, 1>>(hypersd_1dim__, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(hypersd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(hypersd, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(P), "assigning variable hypersd");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          current_statement__ = 3;
          assign(hypersd,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_constrain(hypersd[(sym1__ - 1)][(sym2__ - 1)], 0),
            "assigning variable hypersd");}}
      std::vector<Eigen::Matrix<double, -1, -1>> eta;
      eta = std::vector<Eigen::Matrix<double, -1, -1>>(eta_1dim__, Eigen::Matrix<double, -1, -1>(P, K));
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= eta_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(eta, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(P, K), "assigning variable eta");}
      std::vector<Eigen::Matrix<double, -1, -1>> theta_k;
      theta_k = std::vector<Eigen::Matrix<double, -1, -1>>(theta_k_1dim__, Eigen::Matrix<double, -1, -1>(P, K));
      stan::math::fill(theta_k, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> tau;
      tau = std::vector<Eigen::Matrix<double, -1, -1>>(tau_1dim__, Eigen::Matrix<double, -1, -1>(P, P));
      stan::math::fill(tau, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
          vars__.emplace_back(mu[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= L_Omega_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(L_Omega,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "L_Omega"));}}}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
          vars__.emplace_back(hypersd[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(eta,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "eta"));
          }}}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 8;
      if (logical_eq(pooling_type, 0)) {
        current_statement__ = 7;
        assign(theta_k, cons_list(index_uni(1), nil_index_list()),
          eta[(1 - 1)], "assigning variable theta_k");
      } 
      current_statement__ = 14;
      if (logical_eq(pooling_type, 1)) {
        current_statement__ = 9;
        assign(tau, cons_list(index_uni(1), nil_index_list()),
          diag_pre_multiply(hypersd[(1 - 1)], L_Omega[(1 - 1)]),
          "assigning variable tau");
        current_statement__ = 12;
        if (logical_eq(cumsum, 1)) {
          current_statement__ = 11;
          assign(theta_k, cons_list(index_uni(1), nil_index_list()),
            add(rep_matrix(mu[(1 - 1)], K),
              multiply(tau[(1 - 1)], eta[(1 - 1)])),
            "assigning variable theta_k");
        } else {
          current_statement__ = 10;
          assign(theta_k, cons_list(index_uni(1), nil_index_list()),
            add(rep_matrix(cumulative_sum(mu[(1 - 1)]), K),
              multiply(tau[(1 - 1)], eta[(1 - 1)])),
            "assigning variable theta_k");
        }
      } 
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= theta_k_1dim__; ++sym3__) {
              vars__.emplace_back(
                rvalue(theta_k,
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__),
                      cons_list(index_uni(sym1__), nil_index_list()))),
                  "theta_k"));}}}
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= tau_1dim__; ++sym3__) {
              vars__.emplace_back(
                rvalue(tau,
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__),
                      cons_list(index_uni(sym1__), nil_index_list()))),
                  "tau"));}}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<double> logpd;
      logpd = std::vector<double>(logpd_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 26;
      if (logical_gt(K_test, 0)) {
        current_statement__ = 16;
        assign(logpd, cons_list(index_uni(1), nil_index_list()), 0,
          "assigning variable logpd");
        current_statement__ = 24;
        for (int k = 1; k <= K_test; ++k) {
          current_statement__ = 22;
          for (int p = 1; p <= P; ++p) {
            current_statement__ = 18;
            if (logical_eq(pooling_type, 1)) {
              current_statement__ = 17;
              assign(logpd, cons_list(index_uni(1), nil_index_list()),
                (logpd[(1 - 1)] +
                  normal_lpdf<false>(test_theta_hat_k[(p - 1)][(k - 1)],
                    mu[(1 - 1)],
                    stan::math::sqrt(
                      (pow(
                         rvalue(tau[(1 - 1)],
                           cons_list(index_uni(p),
                             cons_list(index_uni(p), nil_index_list())),
                           "tau[1]"), 2) +
                        pow(test_se_theta_k[(p - 1)][(k - 1)], 2))))),
                "assigning variable logpd");
            } 
            current_statement__ = 20;
            if (logical_eq(pooling_type, 2)) {
              current_statement__ = 19;
              assign(logpd, cons_list(index_uni(1), nil_index_list()),
                (logpd[(1 - 1)] +
                  normal_lpdf<false>(test_theta_hat_k[(p - 1)][(k - 1)],
                    mu[(1 - 1)],
                    stan::math::sqrt(
                      pow(test_se_theta_k[(p - 1)][(k - 1)], 2)))),
                "assigning variable logpd");
            } }}
      } 
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        vars__.emplace_back(logpd[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(mu_1dim__, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_flat__;
        current_statement__ = 1;
        assign(mu_flat__, nil_index_list(), context__.vals_r("mu"),
          "assigning variable mu_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
            current_statement__ = 1;
            assign(mu,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              mu_flat__[(pos__ - 1)], "assigning variable mu");
            current_statement__ = 1;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, -1>> L_Omega;
      L_Omega = std::vector<Eigen::Matrix<double, -1, -1>>(L_Omega_1dim__, Eigen::Matrix<double, -1, -1>(P, P));
      stan::math::fill(L_Omega, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> L_Omega_flat__;
        current_statement__ = 2;
        assign(L_Omega_flat__, nil_index_list(), context__.vals_r("L_Omega"),
          "assigning variable L_Omega_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 2;
            for (int sym3__ = 1; sym3__ <= L_Omega_1dim__; ++sym3__) {
              current_statement__ = 2;
              assign(L_Omega,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                L_Omega_flat__[(pos__ - 1)], "assigning variable L_Omega");
              current_statement__ = 2;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> L_Omega_free__;
      L_Omega_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(L_Omega_1dim__, Eigen::Matrix<double, -1, 1>(
        ((P * (P - 1)) / 2)));
      stan::math::fill(L_Omega_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(L_Omega_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cholesky_corr_free(L_Omega[(sym1__ - 1)]),
          "assigning variable L_Omega_free__");}
      std::vector<Eigen::Matrix<double, -1, 1>> hypersd;
      hypersd = std::vector<Eigen::Matrix<double, -1, 1>>(hypersd_1dim__, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(hypersd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> hypersd_flat__;
        current_statement__ = 3;
        assign(hypersd_flat__, nil_index_list(), context__.vals_r("hypersd"),
          "assigning variable hypersd_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
            current_statement__ = 3;
            assign(hypersd,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              hypersd_flat__[(pos__ - 1)], "assigning variable hypersd");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> hypersd_free__;
      hypersd_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(hypersd_1dim__, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(hypersd_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          current_statement__ = 3;
          assign(hypersd_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_free(hypersd[(sym1__ - 1)][(sym2__ - 1)], 0),
            "assigning variable hypersd_free__");}}
      std::vector<Eigen::Matrix<double, -1, -1>> eta;
      eta = std::vector<Eigen::Matrix<double, -1, -1>>(eta_1dim__, Eigen::Matrix<double, -1, -1>(P, K));
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> eta_flat__;
        current_statement__ = 4;
        assign(eta_flat__, nil_index_list(), context__.vals_r("eta"),
          "assigning variable eta_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 4;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 4;
            for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
              current_statement__ = 4;
              assign(eta,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                eta_flat__[(pos__ - 1)], "assigning variable eta");
              current_statement__ = 4;
              pos__ = (pos__ + 1);}}}
      }
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          vars__.emplace_back(mu[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= ((P * (P - 1)) / 2); ++sym2__) {
          vars__.emplace_back(L_Omega_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          vars__.emplace_back(hypersd_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= eta_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
            vars__.emplace_back(
              rvalue(eta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__), nil_index_list()))), "eta"));
          }}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("mu");
    names__.emplace_back("L_Omega");
    names__.emplace_back("hypersd");
    names__.emplace_back("eta");
    names__.emplace_back("theta_k");
    names__.emplace_back("tau");
    names__.emplace_back("logpd");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(mu_1dim__),
                                             static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(L_Omega_1dim__)
                                             , static_cast<size_t>(P),
                                             static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(hypersd_1dim__)
                                             , static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(eta_1dim__),
                                             static_cast<size_t>(P),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(theta_k_1dim__)
                                             , static_cast<size_t>(P),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(tau_1dim__),
                                             static_cast<size_t>(P),
                                             static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(logpd_1dim__)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= L_Omega_1dim__; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "L_Omega" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "hypersd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= theta_k_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "theta_k" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= tau_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "logpd" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= ((P * (P - 1)) / 2); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= L_Omega_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "L_Omega" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "hypersd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= theta_k_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "theta_k" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= tau_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "logpd" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << P << "}},\"block\":\"parameters\"},{\"name\":\"L_Omega\",\"type\":{\"name\":\"array\",\"length\":" << L_Omega_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << P << "}},\"block\":\"parameters\"},{\"name\":\"hypersd\",\"type\":{\"name\":\"array\",\"length\":" << hypersd_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << P << "}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"array\",\"length\":" << eta_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << K << "}},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"array\",\"length\":" << theta_k_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << K << "}},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" << tau_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << P << "}},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" << logpd_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << P << "}},\"block\":\"parameters\"},{\"name\":\"L_Omega\",\"type\":{\"name\":\"array\",\"length\":" << L_Omega_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((P * (P - 1)) / 2) << "}},\"block\":\"parameters\"},{\"name\":\"hypersd\",\"type\":{\"name\":\"array\",\"length\":" << hypersd_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << P << "}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"array\",\"length\":" << eta_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << K << "}},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"array\",\"length\":" << theta_k_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << K << "}},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" << tau_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << P << "}},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" << logpd_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_mutau_namespace::model_mutau;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_mutau_namespace::profiles__;
}
#endif
#endif
