% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dropout_correction.R
\name{QuantifyDropout}
\alias{QuantifyDropout}
\title{Fit dropout model to quantify dropout frequency}
\usage{
QuantifyDropout(
  obj,
  scale_init = 1.05,
  pdo_init = 0.3,
  keep_data = FALSE,
  no_message = FALSE,
  ...
)
}
\arguments{
\item{obj}{bakRFit object}

\item{scale_init}{Numeric; initial estimate for -s4U/+s4U scale factor. This is the factor
difference in RPM normalized read counts for completely unlabeled transcripts (i.e., highly stable
transcript) between the +s4U and -s4U samples.}

\item{pdo_init}{Numeric; initial estimtae for the dropout rate. This is the probability
that an s4U labeled RNA molecule is lost during library prepartion.}

\item{keep_data}{Logical; if TRUE, will return list with two elements. First element
is the regular return (data frame with dropout quantified), and the second element
will be the data frame that was used for fitting the dropout model. This is useful
if wanting to visualize the fit. See Return documetation for more details}

\item{no_message}{Logical; if TRUE, will not output message regarding estimated
rates of dropout in each sample}

\item{...}{Additional (optional) parameters to be passed to \code{stats::nls()}}
}
\value{
If keep_data is FALSE, then only a data frame with the dropout rate estimates (pdo)
in each sample is returned. If keep_data is TRUE, then a list with two elements is returned. One element is
the pdo data frame always returned, and the second is the data frame containing information passed
to \code{stats::nls} for pdo estimation.
}
\description{
\code{QuantifyDropout} estimates the percentage of 4-thiouridine containing RNA
that was lost during library preparation (pdo).
}
\examples{
\donttest{
# Simulate data for 500 genes and 2 replicates with 40\% dropout
sim <- Simulate_relative_bakRData(500, depth = 100000,
                                  nreps = 2, p_do = 0.4)

# Fit data with fast implementation
Fit <- bakRFit(sim$bakRData)

# Quantify dropout
Fit <- QuantifyDropout(Fit)

}
}
