% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_volcano.R
\name{plot_volcano}
\alias{plot_volcano}
\title{Plot the -log10(err) against the log fold-change}
\usage{
plot_volcano(results, alpha = 0.05, lfc = NULL)
}
\arguments{
\item{results}{Output generated by
\code{baldur::\link[baldur:infer_data_and_decision_model]{infer_data_and_decision_model}}}

\item{alpha}{Significance cut-off; used to draw a line indicating where
significance starts}

\item{lfc}{LFC cut-off; used to draw lines for \code{abs(lfc)}, if \code{NULL} no lines
are drawn}
}
\value{
\code{plot_volcano} returns a \code{ggplot} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{plot_volcano} returns a \code{ggplot} with a graphical representation between the
-log10(err) and LFC.
}
\examples{
# Setup model matrix
design <- model.matrix(~ 0 + factor(rep(1:2, each = 3)))
colnames(design) <- paste0("ng", c(50, 100))

yeast_norm <- yeast \%>\%
# Remove missing data
  tidyr::drop_na() \%>\%
  # Normalize data
  psrn('identifier') \%>\%
  # Add mean-variance trends
  calculate_mean_sd_trends(design)
# Fit the gamma regression
gam <- fit_gamma_regression(yeast_norm, sd ~ mean)
# Estimate each data point's uncertainty
unc <- estimate_uncertainty(gam, yeast_norm, 'identifier', design)
yeast_norm <- gam \%>\%
   # Add hyper-priors for sigma
   estimate_gamma_hyperparameters(yeast_norm)
# Setup contrast matrix
contrast <- matrix(c(-1, 1), 2)
\donttest{
results <- yeast_norm \%>\%
  head() \%>\% # Just run a few for the example
  infer_data_and_decision_model(
    'identifier',
    design,
    contrast,
    unc,
    clusters = 1 # I highly recommend increasing the number of parallel workers/clusters
                 # this will greatly reduce the speed of running baldur
  )
  # Plot indicating where alpha = 0.05
  plot_volcano(results, alpha = 0.05)
  # Plot indicating where alpha = 0.01 and where LFC = 1
  plot_volcano(results, alpha = 0.01, 1)
}
}
