% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bama.R
\name{bama}
\alias{bama}
\title{High Dimensional Bayesian Mediation}
\usage{
bama(Y, A, M, C, beta.m, alpha.a, burnin, ndraws)
}
\arguments{
\item{Y}{numeric outcome vector}

\item{A}{numeric exposure vector}

\item{M}{numeric matrix of mediators of Y and A}

\item{C}{numeric matrix of extra covariates to include}

\item{beta.m}{numeric vector of initial beta.m in the outcome model}

\item{alpha.a}{numeric vector of initial alpha.a in the mediator model}

\item{burnin}{number of iterations to run the MCMC before sampling}

\item{ndraws}{number of draws to take from MCMC after the burnin period}
}
\value{
\code{bama} returns a object of type "bama" with 11 elements each of length
\code{ndraws}), sampled from the burned in MCMC:
\describe{
\item{beta.m}{Outcome model mediator coefficients}
\item{r1}{Whether or not each beta.m belongs to the larger normal
component (1) or smaller normal component (0)}
\item{alpha.a}{Mediator model exposure coefficients}
\item{r3}{Whether or not each alpha.a belongs to the larger normal
component (1) or smaller normal component (0)}
\item{beta.a}{beta.a coefficient}
\item{pi.m}{Proportion of non zero beta.m coefficients}
\item{pi.a}{Proportion of non zero alpha.a coefficients}
\item{sigma.m0}{standard deviation of the smaller normal component for
mediator-outcome coefficients (beta.m)}
\item{sigma.m1}{standard deviation of the larger normal component for
mediator-outcome coefficients (beta.m)}
\item{sigma.ma0}{Standard deviation of the smaller normal component for
exposure-mediator coefficients (alpha.a)}
\item{sigma.ma1}{Standard deviation of the larger normal component for
exposure-mediator coefficients (alpha.a)}
}
}
\description{
\code{bama} is a Bayesian inference method that uses continuous shrinkage priors
for high-dimensional Bayesian mediation analysis, developed by Song et al
(2018). \code{bama} provides estimates for the regression coefficients as
well as the posterior inclusion probability for ranking mediators.
}
\details{
\code{bama} uses two regression models for the two conditional relationships,
\eqn{Y | A, M, C} and \eqn{M | A, C}. For the outcome model, \code{bama}
uses
\deqn{Y = M \beta_M  + A * \beta_A + C* \beta_C + \epsilon_Y}
For the mediator model, \code{bama} uses the model
\deqn{M = A * \alpha_A + C * \alpha_C + \epsilon_M}

For high dimensional tractability, \code{bama} employs continuous Bayesian
shrinkage priors to select mediators and makes the two following assumptions:
First, it assumes that all the potential mediators contribute small effects
in mediating the exposure-outcome relationship. Second, it assumes
that only a small proportion of mediators exhibit large effects
("active" mediators). \code{bama} uses a Metropolis-Hastings within Gibbs
MCMC to generate posterior samples from the model.
}
\examples{
library(bama)

Y <- bama.data$y
A <- bama.data$a

# grab the mediators from the example data.frame
M <- as.matrix(bama.data[, paste0("m", 1:100)], nrow(bama.data))

# We just include the intercept term in this example as we have no covariates
C <- matrix(1, 1000, 1)
beta.m  <- rep(0, 100)
alpha.a <- rep(0, 100)

set.seed(12345)
out <- bama(Y, A, M, C, beta.m, alpha.a, burnin = 1000, ndraws = 100)

# The package includes a function to summarise output from 'bama'
summary <- summary(out)
head(summary)
}
\references{
Yanyi Song, Xiang Zhou et al. Bayesian Shrinkage Estimation of High
Dimensional Causal Mediation Effects in Omics Studies.
bioRxiv \href{https://doi.org/10.1101/467399}{10.1101/467399}
}
\author{
Alexander Rix
}
