% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdr.bama.R
\name{fdr.bama}
\alias{fdr.bama}
\title{Bayesian Mediation Analysis Controlling For False Discovery}
\usage{
fdr.bama(
  Y,
  A,
  M,
  C1,
  C2,
  beta.m,
  alpha.a,
  burnin,
  ndraws,
  weights = NULL,
  npermutations = 200,
  fdr = 0.1,
  k = 2,
  lm0 = 1e-04,
  lm1 = 1,
  l = 1,
  mc.cores = 1,
  type = "PSOCK"
)
}
\arguments{
\item{Y}{Length \code{n} numeric outcome vector}

\item{A}{Length \code{n} numeric exposure vector}

\item{M}{\code{n x p} numeric matrix of mediators of Y and A}

\item{C1}{\code{n x nc1} numeric matrix of extra covariates to include in the
outcome model}

\item{C2}{\code{n x nc2} numeric matrix of extra covariates to include in the
mediator model}

\item{beta.m}{Length \code{p} numeric vector of initial \code{beta.m} in the
outcome model}

\item{alpha.a}{Length \code{p} numeric vector of initial \code{alpha.a} in
the mediator model}

\item{burnin}{Number of iterations to run the MCMC before sampling}

\item{ndraws}{Number of draws to take from MCMC after the burnin period}

\item{weights}{Length \code{n} numeric vector of weights}

\item{npermutations}{The number of permutations to generate while estimating
the null pip distribution. Default is 200}

\item{fdr}{False discovery rate. Default is 0.1}

\item{k}{Shape parameter prior for inverse gamma. Default is 2.0}

\item{lm0}{Scale parameter prior for inverse gamma for the small normal
components. Default is 1e-4}

\item{lm1}{Scale parameter prior for inverse gamma for the large normal
components. Default is 1.0}

\item{l}{Scale parameter prior for the other inverse gamma distributions.
Default is 1.0}

\item{mc.cores}{The number of cores to use while running \code{fdr.bama}.
\code{fdr.bama} uses the \code{parallel} package for parallelization,
so see that for more information. Default is 1 core}

\item{type}{Type of cluster to make when \code{mc.cores > 1}. See
\code{makeCluster} in the \code{parallel} package for more details.
Default is "PSOCK"}
}
\value{
\code{fdr.bama} returns a object of type "fdr.bama" with 5 elements:
\describe{
\item{bama.out}{Output from the \code{bama} run.}
\item{pip.null}{A \code{p x npermutations} matrices containing the
estimated null PIP distribution for each mediator.
}
\item{threshold}{The cutoff significance threshold for each PIP controlling
for the false discovery rate.
}
\item{fdr}{The false discovery rate used to calculate \code{threshold}.}
\item{call}{The R call that generated the output.}
}
}
\description{
\code{fdr.bama} uses the permutation test to estimate the null PIP
distribution for each mediator and determines a threshold (based off of the
\code{fdr} parameter) for significance.
}
\examples{
library(bama)

Y <- bama.data$y
A <- bama.data$a

# grab the mediators from the example data.frame
M <- as.matrix(bama.data[, paste0("m", 1:100)], nrow(bama.data))

# We just include the intercept term in this example as we have no covariates
C1 <- matrix(1, 1000, 1)
C2 <- matrix(1, 1000, 1)
beta.m  <- rep(0, 100)
alpha.a <- rep(0, 100)

set.seed(12345)
\donttest{
out <- fdr.bama(Y, A, M, C1, C2, beta.m, alpha.a, burnin = 100,
                ndraws = 120, npermutations = 10)

# The package includes a function to summarise output from 'fdr.bama'
summary(out)
}
}
\references{
Song, Y, Zhou, X, Zhang, M, et al. Bayesian shrinkage estimation of high
dimensional causal mediation effects in omics studies. Biometrics. 2019;
1-11. \doi{10.1111/biom.13189}
}
\author{
Alexander Rix
}
