% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcompare.R
\name{plotcompare}
\alias{plotcompare}
\title{plotcompare}
\usage{
plotcompare(m1, m2, level = 0.95,
  title = paste("Comparative Predictive Posterior Contours"),
  m1.name = "Model.1", m2.name = "Model.2", group = NULL,
  limits.x = c(0, 1), limits.y = c(0, 1), group.colors = c("blue", "red"))
}
\arguments{
\item{m1}{A model fitted to the data. This is an object generated by the metadiag function.}

\item{m2}{A second model fitted to the data. This is an object generated by the metadiag function.}

\item{level}{Credibility level of the predictive curves.}

\item{title}{The title of the plot.}

\item{m1.name}{Label of the model 1.}

\item{m2.name}{Label of the model 2.}

\item{group}{A factor variable to display data of different groups. The length of group must be the same as the total number of studies used to fit model 1 and model 2.
For example, if 10 studies are used to fit model m1 and 5 studies are used to fit model m2, then
the length(group)=15.}

\item{limits.x}{A vector with the limits of the horizontal axis.}

\item{limits.y}{A vector with the limits of the vertical axis.}

\item{group.colors}{A character vector with two color names.}
}
\description{
This function compares the predictive posterior surfaces of two fitted models.
}
\examples{

## execute analysis
\dontrun{

# Comparing results from two models same data

data(glas)
glas.t <- glas[glas$marker == "Telomerase", 1:4]
glas.m1 <- metadiag(glas.t)
glas.m2 <- metadiag(glas.t, re = "sm")
plotcompare(m1 = glas.m1, m2 = glas.m2)



# Comparing results from two models fitted to two subgroups of data:
# studies with retrospective design and studies with prospective design

 data(ct)
 gr <- with(ct, factor(design,
                       labels = c("Retrospective study", "Prospective study")))

m1.ct <- metadiag(ct[ct$design==1, 1:4]) # Restrospective studies
m2.ct <- metadiag(ct[ct$design==2, 1:4]) # Prospective studies

plotcompare(m1.ct, m2.ct,
           m1.name = "Retrospective design",
           m2.name = "Prospective design",
             group = gr,
          limits.x = c(0, 0.75), limits.y = c(0.65, 1))
}

}
\seealso{
\code{\link{metadiag}}.
}
\keyword{file}

