% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.metadiag.R
\name{plot.metadiag}
\alias{plot.metadiag}
\title{Generic plot function for metadiag object in bamdit}
\usage{
\method{plot}{metadiag}(x, parametric.smooth = TRUE, level = c(0.5,
  0.75, 0.95), limits.x = c(0, 1), limits.y = c(0, 1), kde2d.n = 25,
  color.line = "red",
  title = paste("Posterior Predictive Contours (50\%, 75\% and 95\%)"),
  marginals = TRUE, bin.hist = 30, color.hist = "lightblue",
  S = 500, color.pred.points = "lightblue",
  color.data.points = "blue", ...)
}
\arguments{
\item{x}{The object generated by the metadiag function.}

\item{parametric.smooth}{Indicates if the predictive curve is a parametric or non-parametric.}

\item{level}{Credibility levels of the predictive curve. If parametric.smooth = FALSE, then the probability levels are estimated from the nonparametric surface.}

\item{limits.x}{Numeric vector of length 2 specifying the x-axis limits. The default value is c(0, 1).}

\item{limits.y}{Numeric vector of length 2 specifying the x-axis limits. The default value is c(0, 1).}

\item{kde2d.n}{The number of grid points in each direction for the non-parametric density estimation. Can be scalar or a length-2 inter vector.}

\item{color.line}{Color of the predictive contour line.}

\item{title}{Optional parameter for setting a title in the plot.}

\item{marginals}{Plot the posterior marginal predictive histograms.}

\item{bin.hist}{Number of bins of the marginal histograms.}

\item{color.hist}{Color of the histograms.}

\item{S}{Number of predictive rates to be plotted.}

\item{color.pred.points}{Color of the prosterior predictive rates.}

\item{color.data.points}{Color of the data points.}

\item{...}{\dots}
}
\description{
This function plots the observe data in the ROC (Receiving Operating Charachteristics) space with the
posterior predictive contours. The predictive curves are approximated using a non-parametric smoother
or with a parametric model. For the parametric model the current implementation supports only a
logistic link function. The marginal posterior predictive distributions are ploted outside the ROC space.
}
\examples{



\dontrun{
library(bamdit)
data("glas")
glas.t <- glas[glas$marker == "Telomerase", 1:4]
glas.m1 <- metadiag(glas.t,                # Data frame
                    re = "normal",         # Random effects distribution
                    re.model = "DS",       # Random effects on D and S
                    link = "logit",        # Link function
                    sd.Fisher.rho   = 1.7, # Prior standard deviation of correlation
                    nr.burnin = 1000,      # Iterations for burnin
                    nr.iterations = 10000, # Total iterations
                    nr.chains = 2,         # Number of chains
                    r2jags = TRUE)         # Use r2jags as interface to jags


 plot(glas.m1,                    # Fitted model
      level = c(0.5, 0.75, 0.95), # Credibility levels
      parametric.smooth = TRUE)   # Parametric curve

# Plot results: based on a non-parametric smoother of the posterior predictive rates .......

plot(glas.m1,                    # Fitted model
     level = c(0.5, 0.75, 0.95), # Credibility levels
     parametric.smooth = FALSE)  # Non-parametric curve

# Using the pipe command in the package dplyr and changing some colors .......

library(dplyr)

glas.t \%>\%
 metadiag(re = "normal", re.model ="SeSp") \%>\%
   plot(parametric.smooth = FALSE,
          S = 100,
          color.data.points = "green",
          color.pred.points = "blue",
          color.line = "black")

}
}
\seealso{
\code{\link{metadiag}}.
}
