% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary_print.R
\name{plot.hef}
\alias{plot.hef}
\title{Plot diagnostics for a hef object}
\usage{
\method{plot}{hef}(
  x,
  y,
  ...,
  params = c("hyper", "ru", "pop"),
  which_pop = NULL,
  plot_type = NULL,
  one_plot = FALSE,
  add_legend = FALSE,
  legend_position = "topright",
  legend_text = NULL,
  num = 100
)
}
\arguments{
\item{x}{an object of class "hef", a result of a call to
\code{\link[rust]{ru}}.}

\item{y}{Not used.}

\item{...}{Additional arguments passed to \code{\link[rust]{plot.ru}},
\code{\link[graphics]{hist}} or \code{\link[graphics]{pairs}}.
In particular, \code{ru_scale = TRUE} produces a plot using the
parameterization used for ratio-of-uniforms sampling.}

\item{params}{A character scalar that determines to which parameters the
 plots relate.
\itemize{
  \item{"hyper": }{the posterior sample of \emph{all} hyperparameter
    values in \eqn{\phi} is plotted using \code{\link[rust]{plot.ru}}.}
  \item{"ru": }{then only the posterior sample generated using
    \code{\link[rust]{ru}} is plotted using \code{\link[rust]{plot.ru}}.
    This produces a different plot to \code{params = "hyper"} if \code{ru}
    is used only on a subset of \eqn{\phi}.  For example, this may be
    the case if \code{x} is the result of a call to \code{\link{hanova1}}.
    See vignette("bang-c-anova-vignette", package = "bang") for
    information.}
  \item{"pop": }{posterior samples and/or densities of the
    population-specific parameter \eqn{\theta} are plotted.  The
    population(s) included are determined by \code{which_pop} and the
    type of plot is determined by \code{plot_type}.
    If \code{plot_type} is not supplied then it is set to \code{"dens"}.}
}}

\item{which_pop}{An integer vector or character scalar.
If \code{params = "pop"} then \code{which_pop} indicates which
populations to include in the plot.  If \code{which_pop} is supplied then
\code{params} is set to "pop".  If \code{which_pop = "all"}
then all populations are included.  If there are many populations then
this may fail if \code{plot_type = "pairs"} and/or
\code{one_plot = FALSE}.}

\item{plot_type}{A character scalar that determines the type of plot
 produced when \code{params = "pop"}.  If \code{plot_type} is supplied
 then \code{params} is set automatically to \code{"pop"}.
\itemize{
  \item{"sim": }{histograms of the posterior samples
    of \eqn{\theta} for the populations in \code{which_pop}.}
  \item{"dens": }{estimates of the marginal posterior
    densities of \eqn{\theta} for the populations in \code{which_pop}.}
  \item{"both": }{both the histograms and estimated posterior densities.}
  \item{"pairs": }{pairwise scatter plots of the posterior samples of
    \eqn{\theta} for the populations in \code{which_pop}, which must have
    length greater than one.}
}}

\item{one_plot, add_legend, legend_position, legend_text}{Only relevant if
\code{plot_type = "dens"}.  If \code{one_plot = TRUE} then the estimated
marginal posterior densities are plotted in the same graph and if
\code{add_legend = TRUE} then a legend is added to this plot using
\code{\link[graphics]{legend}} in the position indicated by
the character scalar \code{legend_position}.
A character vector \code{legend_text} may be used to override the
default legend text.}

\item{num}{A numeric scalar.  If \code{plot_type == "dens"} or
\code{plot_type == "both"} then \code{num} gives the number of
points at which the marginal densities are evaluated to produce plots.}
}
\description{
\code{plot} method for class "hef".
}
\section{Examples}{

See the examples in \code{\link{hef}} and \code{\link{hanova1}}.
}

\seealso{
\code{\link[rust]{plot.ru}} for arguments that may be passed
  via ...., in particular \code{ru_scale}.
}
