% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeBarPlot.R
\name{treeBarPlot}
\alias{treeBarPlot}
\title{Plot Frequency of Tree Structures}
\usage{
treeBarPlot(trees, iter = NULL, topTrees = NULL, removeStump = FALSE)
}
\arguments{
\item{trees}{A list of tree graphs to display}

\item{iter}{Optional; specifies the iteration to display.}

\item{topTrees}{Optional; the number of top tree structures to display. If NULL, displays all.}

\item{removeStump}{Logical; if TRUE, trees with no edges (stumps) are excluded from the display}
}
\value{
A `ggplot` object representing the bar plot of tree frequencies.
}
\description{
Generates a bar plot showing the frequency of different tree structures
represented in a list of tree graphs. Optionally, it can filter to show only the top N trees
and handle stump trees specially.
}
\details{
This function processes a list of tree structures to compute the frequency of each unique structure,
represented by a bar plot. It has options to exclude stump trees (trees with no edges) and to limit
the plot to the top N most frequent structures.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6], df[, 1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 plot <- treeBarPlot(trees = trees_data, topTrees = 3, removeStump = TRUE)
}

}
