% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_group.R
\name{quantile_group}
\alias{quantile_group}
\title{Stratify a numeric vector into quantile groups}
\usage{
quantile_group(data, n, na.rm = TRUE)
}
\arguments{
\item{data}{a vector of type numeric with values to be grouped into quantiles}

\item{n}{integer indicating number of quantiles, minimum of 2. Must be smaller than length(data)}

\item{na.rm}{logical; if TRUE all NA values will be removed before calculating groups, if FALSE no NA values are permitted.}
}
\value{
vector of length length(data) with the quantile groups
}
\description{
Transforms a numeric vector into quantile groups. For each input value, the output value corresponds to the quantile that value is in.
When grouping into n quantiles, the lowest 1/n of values are assigned 1, the highest 1/n are assigned n.
}
\details{
Tied values will be assigned to the lower quantile group rather than etsimating a distribution. In extreme cases this can mean one or more quantile groups are not represented.

If uneven group sizes cannot be avoided, values will be assigned the higher quantile group.
}
\author{
J. Peter Marquardt
}
