% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{plot_map}
\alias{plot_map}
\title{Plot the Map Exchangeability of a Basket Trial}
\usage{
plot_map(x, ...)
}
\arguments{
\item{x}{\code{basket} element of the exchangeability model.}

\item{...}{other options passed to ggplot2 to alter the visual}
}
\description{
The Maximum A Posteriori Probability (MAP) of an MEM is the
estimate of the exchangeability structure of a basket trial. This function
visualizes this matrix as an exchangeogram.
}
\details{
The \code{plot_map} function attempts to place the
basket names to the left of the main diagonal in a way that makes it
easy to read. However, for especially long basket names options are
provided. Here is a list of all options available to ``fine tune''
the visualizations. These auxiliary options include:
\itemize{
 \item{[palette]}{A color palette consisting of 3 colors: the first
 corresponds to a low degree of exchangeability, the second to 50%
 exchangeability, and the third to a high degree of exchangeability.
 Interpolation between these colors is performed for intermediary
 degrees of exchangeability. }
 \item{[text_color]}{A text string setting the color of the exchangeability
 values printed on the plot. (Default "white")}
 \item{[tile_color]}{A text string setting the color of the edges of the
 tiles. (Default "white")}
 \item{[expand] }{The proportion to expand the viewport
 (Default expand = c(0.3, 0.3))}
 \item{[text_size] }{The text size. (Default 4)}
 \item{[legend_position] }{The legend position.
   (Default legend_position = c(0.25, 0.8)}
 \item{[draw_legend] }{Should the legend be drawn? (Default TRUE)}
 \item{[basket_name_hoffset] }{The horizontal offset of the basket names..
 (Default 0)}
 \item{[basket_name_hjust] }{The basket name justification..
 (Default 1 - right justified)}
}
}
\examples{
\donttest{
# Create an MEM analysis of the Vemurafenib trial data.
data(vemu_wide)

mem_analysis <- mem_exact(
  vemu_wide$responders,
  vemu_wide$evaluable,
  vemu_wide$baskets
)

plot_map(mem_analysis$basket)
}
}
