% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/batteryreduction.R
\name{batteryreduction}
\alias{batteryreduction}
\title{A function for data reduction}
\usage{
batteryreduction(vars, numfact, data)
}
\arguments{
\item{vars}{a vector of variable names}

\item{numfact}{numeric, number of variables to be selected}

\item{data}{a dataframe}
}
\value{
If numfact=1, reda matrix and selected variable are returned. If numfact>=2, reda matrix, rota matrix, and selected variables are returned.
}
\description{
Battery reduction is a method used in data reduction. It uses Gram-Schmidt orthogonal rotations to find out a subset of variables best representing the originial set of variables.
}
\examples{
## Generate an example dataset
set.seed(1234)
data<-data.frame(x1=rnorm(n=100, mean=14, sd=7),
x2=rnorm(n=100, mean=3, sd=1),
x3=rpois(n=100, lambda=1),
x4=rpois(n=100, lambda=10),
x5=rgamma(n=100, shape=1),
x6=rgamma(n=100, shape=10))
## Demonstrate batteryreduction
vars<-c('x1','x2','x3','x4','x5','x6')
numfact<-3
batteryreduction(vars, numfact, data)
}
\references{
D'Agostino, R. B., & Zhang, Z. (1992). Data/variable reduction by principal components, battery reduction and variable clustering. MATRIX, 7(60), 06.

Hans Werner Borchers (2015). pracma: Practical Numerical Math Functions. R package version 1.8.6. http://CRAN.R-project.org/package=pracma
}

