% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayefdr.R
\name{efdr_search}
\alias{efdr_search}
\title{Bayesian EFDR optimisation.}
\usage{
efdr_search(
  probs,
  target_efdr,
  min_threshold = 0.7,
  prob_thresholds = seq(0.5, 0.9995, by = 0.00025)
)
}
\arguments{
\item{probs}{Vector of probabilities.}

\item{target_efdr}{Numeric scalar specifying the expected false discovery 
rate to match.}

\item{min_threshold}{Minimum probability threshold. If the optimal 
probability threshold is below this number, it is rejected and 
\code{min_threshold} is used instead.}

\item{prob_thresholds}{Vector for probability thresholds to scan,
with the aim of finding the threshold that matches the target EFDR.}
}
\value{
An object of class "bayefdr" containing the probability thresholds 
 tested, the EFDR and EFNR at each probability threshold, and the optimal 
 threshold.
}
\description{
Given a vector of probabilities, this function finds the probability 
threshold that matches a target expected false discovery rate as closely
as possible.
}
\examples{
 probs <- runif(100)
 efdr <- efdr_search(probs, target_efdr = 0.1)
 plot(efdr)
}
