% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pw_exp.R
\name{pw_exp_sim}
\alias{pw_exp_sim}
\title{Simulates time-to-event outcomes.}
\usage{
pw_exp_sim(hazard, n, maxtime = NULL, cutpoint = NULL)
}
\arguments{
\item{hazard}{vector. The constant hazard rates for exponential failures.}

\item{n}{scalar. The number of outcomes for simulation.}

\item{maxtime}{scalar. maximum time before end of study.}

\item{cutpoint}{vector. The change-point vector indicating time when the hazard rates change.}
}
\value{
a dataset with simulated follow-up time (time) and respective event indicator (1 = event,
         0 = censoring)
}
\description{
Simulation of time-to-event outcomes using
the piecewise constant hazard exponential function.
}
\examples{
pw_exp_sim(c(0.02, 0.01, 0.005), 100, 100, c(10, 20))
          pw_exp_sim(0.015, 100, 100)


}
