% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial-class.R
\name{initial}
\alias{initial}
\title{Initial values constructor for bayesPO modeling}
\usage{
initial(
  beta = numeric(),
  delta = numeric(),
  lambdaStar = numeric(),
  random = FALSE
)
}
\arguments{
\item{beta}{Either a vector or a single integer. The vector is used if the
initial values are provided and the integer is used as the vector size to
be randomly generated.}

\item{delta}{Either a vector or a single integer. The vector is used if the
initial values are provided and the integer is used as the vector size to
be randomly generated.}

\item{lambdaStar}{A positive number.}

\item{random}{A logical value. If \code{TRUE}, then the initial values are
generated from standard normal distribution for \code{beta} and \code{delta}
and from a \code{Beta(lambdaStar, 1)} for \code{lambdaStar}. The latter is
generated as a low value due to potential explosive values resulting from
background area scaling.}
}
\value{
A \code{bayesPO_initial} object. It can be used in the
\code{fit_bayesPO} function by itself, but must be in a list if multiple
initial values are supplied. Initial values can be combined by adding them
(with the use of `+`).
}
\description{
Helper function to create a valid set of initial values to be used with the
fit_bayesPO function.
}
\seealso{
\code{\link{bayesPO_initial-class}}.
}
