% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_Xn.R
\name{gen_Xn}
\alias{gen_Xn}
\title{Design Matrix Generator}
\usage{
gen_Xn(n)
}
\arguments{
\item{n}{vector of sample sizes. Length of \code{n} corresponds
to the number of groups being assessed in the study design
as well as the column dimension of the design matrix.}
}
\value{
Xn: a design matrix that can be used to assess the
Bayesian assurance through Monte Carlo sampling using
functions presented in this package.
}
\description{
Constructs design matrix using given sample size(s).
Used for assurance analysis in the Bayesian setting.
}
\examples{
## In the following example, notice that passing in a vector
## of length 4 returns a design matrix of column dimension 4, where
## each column is comprised of ones vectors with lengths that correspond
## to the inputted sample sizes.

n <- c(1,3,5,8)
gen_Xn(n = n)
}
\seealso{
\code{\link{gen_Xn_longitudinal}}
}
