% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{vcov.bayesianVARs_bvar}
\alias{vcov.bayesianVARs_bvar}
\title{Extract posterior draws of the (time-varying) variance-covariance matrix for
a VAR model}
\usage{
\method{vcov}{bayesianVARs_bvar}(object, ...)
}
\arguments{
\item{object}{An object of class \code{bayesianVARs_bvar} obtained via \code{\link[=bvar]{bvar()}}.}

\item{...}{Currently ignored.}
}
\value{
An array of class \code{bayesianVARs_draws} of dimension \eqn{T \times M
  \times M \times draws}, where \eqn{T} is the number of observations,
\eqn{M} the number of time-series and \eqn{draws} the number of stored
posterior draws.
}
\description{
Returns the posterior draws of the possibly time-varying variance-covariance
matrix of a VAR estimated via \code{\link[=bvar]{bvar()}}. Returns the full paths if
\code{sv_keep="all"} when calling \code{\link[=bvar]{bvar()}}. Otherwise, the draws of the
variance-covariance matrix for the last observation are returned, only.
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]
# Estimate a model
mod <- bvar(data, sv_keep = "all", quiet = TRUE)

# Extract posterior draws of the variance-covariance matrix
bvar_vcov <- vcov(mod)
}
\seealso{
\code{\link{summary.bayesianVARs_draws}}, \code{\link[=coef.bayesianVARs_bvar]{coef.bayesianVARs_bvar()}}.
}
