% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.bayesmanecfit}
\alias{autoplot.bayesmanecfit}
\title{autoplot.bayesmanecfit}
\usage{
\method{autoplot}{bayesmanecfit}(
  object,
  ...,
  nec = TRUE,
  ecx = FALSE,
  force_x = FALSE,
  xform = NA,
  all_models = FALSE,
  plot = TRUE,
  ask = TRUE,
  newpage = TRUE,
  multi_facet = TRUE
)
}
\arguments{
\item{object}{An object of class \code{\link{bayesmanecfit}} as returned by
function \code{\link{bnec}}.}

\item{...}{Additional arguments to be passed to \code{\link{ggbnec_data}}.}

\item{nec}{Should NEC values be added to the plot? Defaults to TRUE.}

\item{ecx}{Should ECx values be added to the plot? Defaults to FALSE.}

\item{force_x}{A \code{\link[base]{logical}} value indicating if the argument
\code{xform} should be forced on the predictor values. This is useful when
the user transforms the predictor beforehand
(e.g. when using a non-standard base function).}

\item{xform}{A function to apply to the returned estimated concentration
values.}

\item{all_models}{Should all individual models be plotted separately\
(defaults to FALSE) or should model averaged predictions be plotted instead?}

\item{plot}{Should output \code{\link[ggplot2]{ggplot}} output be plotted?
Only relevant if \code{all = TRUE} and \code{multi_facet = FALSE}.}

\item{ask}{Indicates if the user is prompted before a new page is plotted.
Only relevant if \code{plot = TRUE} and \code{multi_facet = FALSE}.}

\item{newpage}{Indicates if the first set of plots should be plotted to a
new page. Only relevant if \code{plot = TRUE} and
\code{multi_facet = FALSE}.}

\item{multi_facet}{Should all plots be plotted in one single panel via
facets? Defaults to TRUE.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
\code{\link[bayesnec:bayesnec-package]{bayesnec}} standard \pkg{ggplot2}
plotting method.
}
\examples{
\donttest{
library(brms)
library(bayesnec)
options(mc.cores = 2)
data(nec_data)

necs <- bnec(y ~ crf(x, c("nec3param", "nec4param")), data = nec_data,
             iter = 2e2, family = Beta(link = "identity"))
nec3param <- pull_out(necs, "nec3param")
autoplot(nec3param)
autoplot(nec3param, nec = FALSE)
autoplot(nec3param, ecx = TRUE, ecx_val = 50)

# plot model averaged predictions
autoplot(necs)
# plot all panels together
autoplot(necs, ecx = TRUE, ecx_val = 50, all_models = TRUE)
# plots multiple models, one at a time, with interactive prompt
autoplot(necs, ecx = TRUE, ecx_val = 50, all_models = TRUE,
         multi_facet = FALSE)
}
}
\seealso{
Other autoplot methods: 
\code{\link{autoplot.bayesnecfit}()}
}
\concept{autoplot methods}
