% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_rope.R
\name{p_rope}
\alias{p_rope}
\alias{p_rope.numeric}
\alias{p_rope.stanreg}
\alias{p_rope.brmsfit}
\title{Probability of being in the ROPE}
\usage{
p_rope(x, ...)

\method{p_rope}{numeric}(x, range = "default", verbose = TRUE, ...)

\method{p_rope}{stanreg}(
  x,
  range = "default",
  effects = c("fixed", "random", "all"),
  component = c("location", "all", "conditional", "smooth_terms", "sigma",
    "distributional", "auxiliary"),
  parameters = NULL,
  verbose = verbose,
  ...
)

\method{p_rope}{brmsfit}(
  x,
  range = "default",
  effects = c("fixed", "random", "all"),
  component = c("conditional", "zi", "zero_inflated", "all"),
  parameters = NULL,
  verbose = verbose,
  ...
)
}
\arguments{
\item{x}{Vector representing a posterior distribution. Can also be a
\code{stanreg} or \code{brmsfit} model.}

\item{...}{Currently not used.}

\item{range}{ROPE's lower and higher bounds. Should be \code{"default"} or
depending on the number of outcome variables a vector or a list. In
models with one response, \code{range} should be a vector of length two (e.g.,
\code{c(-0.1, 0.1)}). In multivariate models, \code{range} should be a list with a
numeric vectors for each response variable. Vector names should correspond
to the name of the response variables. If \code{"default"} and input is a vector,
the range is set to \code{c(-0.1, 0.1)}. If \code{"default"} and input is a Bayesian
model, \code{\link[=rope_range]{rope_range()}} is used.}

\item{verbose}{Toggle off warnings.}

\item{effects}{Should results for fixed effects, random effects or both be
returned? Only applies to mixed models. May be abbreviated.}

\item{component}{Should results for all parameters, parameters for the
conditional model or the zero-inflated part of the model be returned? May
be abbreviated. Only applies to \pkg{brms}-models.}

\item{parameters}{Regular expression pattern that describes the parameters
that should be returned. Meta-parameters (like \code{lp__} or \code{prior_}) are
filtered by default, so only parameters that typically appear in the
\code{summary()} are returned. Use \code{parameters} to select specific parameters
for the output.}
}
\description{
Compute the proportion of the whole posterior distribution that doesn't lie within a region of practical equivalence (ROPE). It is equivalent to running \code{rope(..., ci = 1)}.
}
\examples{
library(bayestestR)

p_rope(x = rnorm(1000, 0, 0.01), range = c(-0.1, 0.1))
p_rope(x = mtcars, range = c(-0.1, 0.1))
}
