% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newCppModel.R
\name{newCppModel}
\alias{newCppModel}
\title{Create a new C++ model object with parameters}
\usage{
newCppModel(modelParameters, verbose = FALSE)
}
\arguments{
\item{modelParameters}{List of model parameters created using functions from
constructors.R, such as:
\itemize{
\item \code{LogNormalModelParams()} - Basic log-normal model
\item \code{LinearAbxModel()} - Linear antibiotic model
\item Or custom parameter lists containing:
\itemize{
\item \code{modname}: Model name ("LogNormalModel", "LinearAbxModel", "LinearAbxModel2", "MixedModel")
\item \code{nstates}: Number of states (2 or 3)
\item \code{nmetro}: Number of Metropolis-Hastings steps
\item \code{forward}: Forward simulation flag
\item \code{cheat}: Cheat flag for debugging
\item \code{Insitu}: In situ parameters from \code{InsituParams()}
\item \code{SurveillanceTest}: Surveillance test parameters from \code{SurveillanceTestParams()}
\item \code{ClinicalTest}: Clinical test parameters from \code{ClinicalTestParams()}
\item \code{OutCol}: Out-of-unit infection parameters from \code{OutOfUnitInfectionParams()}
\item \code{InCol}: In-unit parameters from \code{InUnitParams()} or \code{ABXInUnitParams()}
\item \code{Abx}: Antibiotic parameters from \code{AbxParams()}
\item \code{AbxRate}: Antibiotic rate parameters from \code{AbxRateParams()}
}
}}

\item{verbose}{Logical flag to print progress messages during model creation
and parameter setup (default: FALSE)}
}
\value{
A reference class object wrapping the C++ model. The specific class depends
on \code{modelParameters$modname}:
\itemize{
\item \code{CppLogNormalModel} - For "LogNormalModel"
\item \code{CppLinearAbxModel} - For "LinearAbxModel"
\item \code{CppLinearAbxModel2} - For "LinearAbxModel2"
\item \code{CppMixedModel} - For "MixedModel" (if exposed in C++)
}

All returned objects inherit from \code{CppBasicModel} and provide access to:
\itemize{
\item \strong{Properties:}
\itemize{
\item \code{InColParams} - In-unit colonization parameters
\item \code{OutColParams} - Out-of-unit colonization parameters
\item \code{InsituParams} - In situ parameters
\item \code{SurveillanceTestParams} - Surveillance test parameters
\item \code{ClinicalTestParams} - Clinical test parameters
\item \code{AbxParams} - Antibiotic parameters
}
\item \strong{Methods:}
\itemize{
\item \code{logLikelihood(hist)} - Calculate log likelihood for a SystemHistory
\item \code{getHistoryLinkLogLikelihoods(hist)} - Get individual link log likelihoods
\item \code{forwardSimulate(...)} - Perform forward simulation
\item \code{initEpisodeHistory(...)} - Initialize episode history
\item \code{sampleEpisodes(...)} - Sample episodes
\item \code{setAbx(...)} - Set antibiotic parameters
}
}
}
\description{
Creates and initializes a C++ model object based on the provided parameters.
This function wraps the underlying C++ model classes (LogNormalModel, LinearAbxModel,
LinearAbxModel2, MixedModel) in appropriate R reference classes that expose
the model's methods and properties.
}
\details{
The function uses the existing \code{newModel} C++ function to instantiate the model
and configure all parameters, then wraps it in the appropriate R reference class
based on the model type specified in \code{modelParameters$modname}.
}
\examples{
\donttest{
# Create a linear antibiotic model (recommended - stable constructors)
params <- LinearAbxModel()
model <- newCppModel(params)

# Access model properties
inColParams <- model$InColParams
insituParams <- model$InsituParams

# Get parameter values
paramValues <- inColParams$values

# Get parameter names (if available)
paramNames <- inColParams$names

# Create a log-normal model
params <- LogNormalModelParams("LogNormalModel")
model <- newCppModel(params, verbose = TRUE)
}

}
\seealso{
\itemize{
\item \code{\link[=LogNormalModelParams]{LogNormalModelParams()}} for creating model parameters
\item \code{\link[=LinearAbxModel]{LinearAbxModel()}} for linear antibiotic model parameters
\item \code{\link[=InsituParams]{InsituParams()}}, \code{\link[=SurveillanceTestParams]{SurveillanceTestParams()}}, etc. for parameter components
\item \code{\link[=newModelExport]{newModelExport()}} for extracting parameter values from a model
}
}
