% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_format.R
\name{format.lcens}
\alias{format.lcens}
\alias{format.mcens}
\alias{format.qw}
\title{Encode in a Common Format}
\usage{
\method{format}{lcens}(x, digits = NULL, ...)

\method{format}{mcens}(x, digits = NULL, ...)

\method{format}{qw}(x, round = TRUE, units = FALSE, style = "asis",
  ...)
}
\arguments{
\item{x}{the censored data object to format.}

\item{digits}{how many significant digits are to be used for numbers?}

\item{\dots}{further arguments passed to or from other methods.}

\item{round}{round the data before formating? Can also be a numeric vector of
length 2 containing the maximum number of significant digits and the maximum
number of decimal digits.}

\item{units}{logical, if \code{TRUE} then include the units of the data.}

\item{style}{the style for objects of class "qw." See \bold{Details}.}
}
\value{
A character representations of the elements of \code{x}.
}
\description{
Formats data for pretty printing: methods for "lcens," "mcens," and "qw" data.
}
\details{
The argument \code{style} must be one of "asis," which tries to format
the data to best show the values; "simple," which is like "asis" except that interval
censored data are the midrange values preceded by "I"; or "interpreted," which shows 
the values as they would be used in analysis and \code{round} is ignored.
Only the first letter is required.
}
\note{
For \code{style} set to "asis," it is often useful to set \code{round} to a
single value so that the interval data are not rounded to the same value.
}
\examples{

format(as.lcens(1:3, 1))
format(as.mcens(1:3, 1:3))

}
\keyword{internal}
\keyword{manip}
