% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrGraphs_setPlot.R
\name{setPlot}
\alias{setPlot}
\title{Plot Parameters}
\usage{
setPlot(current, name = "", what = "lines", type = "solid",
  width = "standard", symbol = "circle", filled = TRUE,
  size = 0.09, color = "black", area.color = NA, area.border = NA)
}
\arguments{
\item{current}{list containing the current plot information or those requested
by the user.}

\item{name}{the name of the object plotted; used in the explanation. Expressions
can be used, but if used, then \code{name} must be and expression for all calls that
update the current plot information.}

\item{what}{what to plot, see \bold{Details}.}

\item{type}{the line type, if drawn, must be one of "solid," "dashed," or
"dotted."}

\item{width}{the width of the line, if drawn, must be one of "standard;"
"color," a little wider than "standard;" "bold," substantially wider than
"standard;" or "hairline," used for ticks and borders.}

\item{symbol}{the symbol to plot, if drawn, see \bold{Details}.}

\item{filled}{logical, if \code{TRUE} and a symbol is drawn, then fill with solid color.}

\item{size}{the size of the symbol, in inches, if drawn.}

\item{color}{the color of the symbol or line.}

\item{area.color}{the color of a shaded area, required for completeness.}

\item{area.border}{the boundary color of a shaded area, required for
completeness.}
}
\value{
A list like \code{current}, but with the defaults supplied for any
missing component.
}
\description{
Sets the plot control list (support function).
}
\details{
Added from smwrGraphs.

The value for \code{what} must be one of: \describe{ \item{"points"}{symbols
only,} \item{"lines"}{lines only,} \item{"both"}{lines connecting symbols
with a small gap,} \item{"overlaid"}{lines connecting symbols,}
\item{"stairstep"}{horizontal line to next x value with a vertical line to
the y value,} \item{"vertical"}{vertical lines from y equal 0 only.}
\item{"none"}{draw nothing} } The value for \code{symbol} must be one of:
\describe{ \item{"circle"}{an open or filled circle, depending on
\code{filled},} \item{"uptri"}{an open or filled up pointing triangle,
depending on \code{filled},} \item{"plus"}{a plus sign (never filled),}
\item{"x"}{an x (never filled),} \item{"diamond"}{an open or filled diamond
shape, depending on \code{filled},} \item{"downtri"}{an open  or filled 
down pointing triangle, depending on \code{filled},} \item{"square"}{an open
 or filled square, depending on \code{filled},} \item{"dot"}{a very small dot
(never filled),} \item{"+"}{a plus sign (never filled),} \item{"none"}{no
symbol or line.} }
}
\note{
Vertical lines drawn by setting \code{what} to "vertical" are drawn from 
y equal 0 to each y value. The user will have more control over vertical lines by
using the \code{addBars} function and setting the bar width to 0.
}
\keyword{hplot}
\keyword{internal}
