% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{freq2raw}
\alias{freq2raw}
\title{Convert Frequency Table into Raw Data}
\usage{
freq2raw(data, freq)
}
\arguments{
\item{data}{Data frame with factors in columns}

\item{freq}{Vector of frequency of each row in \code{data}; can be a named column 
in \code{data}; if missing, the column \code{Freq} is looked for in \code{data}}
}
\value{
Data frame with one row per instances
}
\description{
Data with unique rows and a frequency column is converted into
data with duplicate rows.
}
\details{
The ouput data frame can be used as input to \code{\link{bbl}}.
}
\examples{
Titanic
x <- as.data.frame(Titanic)
head(x)
titanic <- freq2raw(data=x[,1:3], freq=x$Freq)
head(titanic)
}
