% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerBatchLocalSearch.R
\name{mlr_optimizers_local_search}
\alias{mlr_optimizers_local_search}
\alias{OptimizerBatchLocalSearch}
\title{Optimization via Local Search}
\description{
\code{OptimizerBatchLocalSearch} class that implements a simple Local Search.
Local Search starts by determining the \code{n_initial_points} initial best points present in the \link{Archive} of the \link{OptimInstance}.
If fewer points than \code{n_initial_points} are present, additional \code{initial_random_sample_size} points sampled uniformly at random are evaluated and the best \code{n_initial_points} initial points are determined.

In each iteration, for each of the \code{n_initial_points} initial best points, \code{neighbors_per_point} neighbors are generated by local mutation.
Local mutation generates a neighbor by sampling a single parameter that is to be mutated and then proceeds as follows: Double parameters (\code{\link[paradox:Domain]{paradox::p_dbl()}}) are mutated via Gaussian mutation (with a prior standardization to \verb{[0, 1]} and retransformation after mutation).
Integer parameters (\code{\link[paradox:Domain]{paradox::p_int()}}) undergo the same mutation but are rounded to the closest integer after mutation.
Categorical parameters (\code{\link[paradox:Domain]{paradox::p_fct()}} and \code{\link[paradox:Domain]{paradox::p_lgl()}}) are mutated via uniform mutation.
Note that parameters that are conditioned on (i.e., they are parents of a \link[paradox:Condition]{paradox::Condition}, see the dependencies of the search space) are not mutated.
}
\section{Dictionary}{

This \link{Optimizer} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_optimizers} or with the associated sugar function \code{\link[=opt]{opt()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_optimizers$get("local_search")
opt("local_search")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\describe{
\item{\code{n_initial_points}}{\code{integer(1)}\cr
Size of the set of initial best points which are used as starting points for the Local Search.
Default is \code{10}.}
\item{\code{initial_random_sample_size}}{\code{integer(1)}\cr
Number of points that are sampled uniformly at random before the best \code{n_initial_points} initial points are determined, if fewer points than \code{n_initial_points} are present in the \link{Archive} of the \link{OptimInstance}.
Default is \code{100}.}
\item{\code{neighbors_per_point}}{\code{integer(1)}\cr
Number of neighboring points to generate for each of the \code{n_initial_points} best starting points in each iteration.
Default is \code{100}.}
\item{\code{mutation_sd}}{\code{numeric(1)}\cr
Standard deviation used to create neighbors during mutation of numeric parameters on the standardized \verb{[0, 1]} scale.
Default is \code{0.1}.}
}
}

\section{Archive}{

The \link{Archive} holds the following additional column that is specific to the algorithm:
\itemize{
\item \code{.point_id} (\code{integer(1)})\cr
The id (\verb{1, ..., n_initial_points}) indicating from which of the \code{n_initial_points} best points the evaluated point was generated from.
}
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\examples{
search_space = domain = ps(x = p_dbl(lower = -1, upper = 1))

codomain = ps(y = p_dbl(tags = "minimize"))

objective_function = function(xs) {
  list(y = as.numeric(xs)^2)
}

objective = ObjectiveRFun$new(
 fun = objective_function,
 domain = domain,
 codomain = codomain)

instance = OptimInstanceBatchSingleCrit$new(
 objective = objective,
 search_space = search_space,
 terminator = trm("evals", n_evals = 100))

# evaluate an initial sample of 10 points uniformly at random
# choose the best 3 points as the initial points
# for each of these points generate 10 neighbors
# repeat this process
optimizer = opt("local_search",
  n_initial_points = 3,
  initial_random_sample_size = 10,
  neighbors_per_point = 10)

# modifies the instance by reference
optimizer$optimize(instance)

# returns best scoring evaluation
instance$result

# allows access of data.table of full path of all evaluations
as.data.table(instance$archive$data)
}
\section{Super classes}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{\link[bbotk:OptimizerBatch]{bbotk::OptimizerBatch}} -> \code{OptimizerBatchLocalSearch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerBatchLocalSearch-new}{\code{OptimizerBatchLocalSearch$new()}}
\item \href{#method-OptimizerBatchLocalSearch-clone}{\code{OptimizerBatchLocalSearch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-format'><code>bbotk::Optimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-help'><code>bbotk::Optimizer$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-print'><code>bbotk::Optimizer$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimizerBatch" data-id="optimize"><a href='../../bbotk/html/OptimizerBatch.html#method-OptimizerBatch-optimize'><code>bbotk::OptimizerBatch$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchLocalSearch-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchLocalSearch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchLocalSearch$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchLocalSearch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchLocalSearch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchLocalSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
