% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bcgam.R
\name{plot.bcgam}
\alias{plot.bcgam}
\title{2D plots for \pkg{bcgam} fits}
\usage{
\method{plot}{bcgam}(x, x1, interval = "credible", parameter = "mu",
  x1.grid = 100, level = 0.95, type = "l", col = 1, col.inter = col,
  lty = 1, lty.inter = 2, lwd = 1, lwd.inter = lwd, ylim = NULL, ...)
}
\arguments{
\item{x}{Object of class inheriting from "bcgam".}

\item{x1}{A non-parametrically modelled predictor in a bcgam fit. There is no default variable.}

\item{interval}{Type of interval to plot. It can be either \code{"credible"} or \code{"prediction"}.
\code{interval="prediction"} only works for the gaussian family. In this case, the predictive posterior distribution is plotted. 
The default is \code{"credible"}.}

\item{parameter}{The type of parameter to be plotted. If parameter=\code{"eta"}, then the systematic component
\eqn{\eta} is plotted. If parameter=\code{"mu"}, then the mean value \eqn{\mu} obtained by transforming
\eqn{\eta} using the inverse of the link function is plotted. The default is \code{"mu"}. 
If \code{interval="prediction"}, then this variable is ignored.}

\item{x1.grid}{A positive integer that specifies how dense the \eqn{x} grid will be. The default is \code{100}.}

\item{level}{Tolerance/credible level. The default is \code{0.95}.}

\item{type}{What type of plot should be drawn. The default is for lines (\code{"l"}).}

\item{col}{Color of fitted values. The default is black (\code{1}).}

\item{col.inter}{Color of interval estimates. If not specified, it takes the
same value as \code{col}.}

\item{lty}{What type of line should be drawn for fitted values. Ignored when a line is not being drawn. 
The default is a solid line (\code{1}).}

\item{lty.inter}{What type of line should be drawn for interval estimates. The default is a dotted line (\code{2}).}

\item{lwd}{The line width of fitted values, a positive number, defaulting to \code{1}.}

\item{lwd.inter}{The line width of interval estimates, a positive number, defaulting to \code{1}.}

\item{ylim}{The \code{y} limits of the plot. If \code{ylim=NULL}, then the minimum value
of the lower bound estimates and the maximum value of the upper bound estimates are used.
The default is \code{NULL}.}

\item{...}{other parameters to be passed through to plotting functions.}
}
\description{
2D plots of predicted values with interval estimates based on a \code{bcgam} object and one non-parametrically
modelled predictor.
}
\details{
\code{plot.bcgam} produces 2D plots based on the \code{bcgam} object. Interval
estimates are based on the specified \code{level}. 

If there are more than one non-parametrically modelled predictors,
then these will be evaluated at the largest values that are smaller than or equal 
to their median values. Categorical covariates will be evaluated at their mode. Also,
continuous covariates will be evaluated at the largest values that are smaller than
or equal to their median values.

This routine creates 2D plots based on the posterior distribution in the \code{bcgam} object.
}
\examples{
\dontrun{
n<-50
x1<-(1:n/n)^{1/3}
x2<-log(1:n/n)
z<-as.factor(rbinom(n, 1, 0.6))
eta<-x1+x2+0.2*as.numeric(z)+rnorm(n, sd=0.2)
mu<-exp(eta)/(1+exp(eta))
y<-(mu<0.6)

bcgam.fit <- bcgam(y~sm.incr(x1)+sm.conc(x2, numknots=8)+z, nloop=10000, family="binomial")
plot(bcgam.fit, x1, parameter="mu", col=4, level=0.90)
plot(bcgam.fit, x2, parameter="eta", col=3, col.inter=2)
}
}
\author{
Cristian Oliva-Aviles and Mary C. Meyer
}
\keyword{internal}
