% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_bcgam.R
\name{summary.bcgam}
\alias{summary.bcgam}
\title{Summarizing \pkg{bcgam} fits}
\usage{
\method{summary}{bcgam}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"bcgam"}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The function \code{summary.bcgam} computes and return a list of summary
statistics (estimated mean, standard error, 95\% bounds, estimated median) of the fitted \code{bcgam} given in \code{object}.
}
\description{
\code{summary} method for class \code{"bcgam"}.
}
\details{
All summary statistics are based on the posterior distribution in the \code{bcgam} object.
}
\examples{
\dontrun{
n<-50
x<-(1:n)^{1/3}
z<-as.factor(rbinom(n, 1, 0.6))
y<-x+7*as.numeric(z)+rnorm(n,sd=2) 
bcgam.fit <- bcgam(y~sm.incr(x)+z, nloop=100)
summary(bcgam.fit)
}
}
\author{
Cristian Oliva-Aviles and Mary C. Meyer
}
