% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_units.R
\name{search_units}
\alias{search_units}
\title{Search for units}
\usage{
search_units(name, level = NULL, year = NULL, kind = NULL,
  sort = c("id", "-id", "name", "-name"), lang = c("pl", "en"), ...)
}
\arguments{
\item{name}{A phrase to search.}

\item{level}{A number from 0 to 6, filters the returned unit by its level.
If \code{NULL} (default) no level filters apply. Use \code{\link{get_levels}} to find more info.}

\item{year}{A vector of years. If \code{NULL} (default) returns data for all available years.}

\item{kind}{A type of unit. More info at: \url{https://bdl.stat.gov.pl/BDL/metadane/teryt/rodzaj}}

\item{sort}{A type of sorting, "id" (default), "-id", "name", "-name"}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A dataset as a tibble.
}
\description{
Search for a given phrase in unit names.
}
\details{
To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
 \donttest{
   search_units("wro")
   search_units("pol", type = "5")
}
}
\keyword{search}
\keyword{units}
\keyword{utilities}
