% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindEmojiPipe.R
\docType{class}
\name{FindEmojiPipe}
\alias{FindEmojiPipe}
\title{Class to find and/or replace the emoji on the data field of an Instance}
\usage{
FindEmojiPipe
}
\description{
This class is responsible of detecting the existing emojis in the
\strong{data} field of each \code{\link{Instance}}. Identified emojis are
stored inside the \strong{emoji} field of \code{\link{Instance}} class.
Moreover if required, is able to perform inline emoji replacement.
}
\section{Constructor}{

\preformatted{
FindEmojiPipe$new(propertyName = "emoji",
                  alwaysBeforeDeps = list(),
                  notAfterDeps = list(),
                  replaceEmojis = TRUE)
}

\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
\item{\strong{replaceEmojis:}}{
(\emph{logical}) indicates if the emojis are replaced.
}
}
}
}
}

\section{Details}{

\code{\link{FindEmojiPipe}} use the emoji list provided by rtweet package.
}

\section{Note}{

\code{\link{FindEmojiPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain/replace the emojis.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
}
}
}
}

\item{\bold{findEmoji:}}{
checks for the existence of an specific emoji.
\itemize{
\item{\emph{Usage:}}{
\code{findEmoji(data, emoji)}
}
\item{\emph{Value:}}{
boolean, depending on whether the emoji is on the data.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text to search the emoji.
}
\item{\strong{emoji:}}{
(\emph{character}) indicates the emoji to find.
}
}
}
}
}

\item{\bold{replaceEmoji:}}{
replaces the emoji in the data for the extendedEmoji.
\itemize{
\item{\emph{Usage:}}{
\code{replaceEmoji(emoji, extendedEmoji, data)}
}
\item{\emph{Value:}}{
the data with emoji replaced.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{emoji:}}{
(\emph{character}) indicates the emoji to remove.
}
\item{\strong{extendedEmoji:}}{
(\emph{character}) determines the text source to replace the emoji found.
}
\item{\strong{data:}}{
(\emph{character}) text where emojis will be replaced.
}
}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{replaceEmojis:}}{
 (\emph{logical}) indicates if the emojis are replaced.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{GenericPipe}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
