% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fcs.R
\name{apply_compensation}
\alias{apply_compensation}
\title{Apply compensation}
\usage{
apply_compensation(.flow_frame, .compensation)
}
\arguments{
\item{.flow_frame}{A \code{flowFrame}. Usually the result of \code{read.FCS}
from \code{flowCore}.}

\item{.compensation}{A character vector, a compensation matrix, or
\code{NULL}. See 'Details' for extended information of the argument.}
}
\value{
A compensated \code{flowFrame}
}
\description{
A compensation matrix is applied
}
\details{
The \code{.compensation} argument takes a character vector or an actual
compensation matrix. In case of the latter, it must be a object of class
\code{matrix}. If an object of class \code{character} is given to the
\code{.compensation} argument, it can be the keyword 'guess' or a search
pattern matching the keyword in the fcs file that contains the compensation
matrix. If the keyword 'guess' is passed, the function looks for a matrix at
the keywords "SPILL" and "SPILLOVER", and if none are found it takes the
first matrix which contains the parameter names as column names. Finally, the
values of \code{.compensation} can also be \code{NULL}, in which case, no
compensation is performed.

To summarise, the argument \code{.compensation} can be:

\describe{
\item{A numerical matrix}{The compensation matrix to apply}
\item{A character}{
\describe{
\item{The word 'guess'}{Looks for a matrix at the keywords "SPILL"
and "SPILLOVER". If none found the first matrix with parameter names is
applied}
\item{A search string}{The first matrix found within the keywords
matching the given search string is applied. The search string can be a
regular expression}
}
}
\item{NULL}{Nothing is done}
}
}
\examples{
\dontrun{
library(beadplexr)
library(flowCore)
.file_name <- system.file("extdata", "K2-C07-A7.fcs",
                          package = "beadplexr")
# Load the fcs file
.flow_frame <- read.FCS(filename = .file_name,
                                 transformation = FALSE)
# Apply compensation by guessing the matrix
.flow_frame <- apply_compensation(.flow_frame = .flow_frame,
                            .compensation = "guess")
}

}
\seealso{
\code{\link[flowCore]{compensation-class}} for the compensation.
}
\keyword{internal}
