#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.12

#include <stan/model/model_header.hpp>

namespace model_bs_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_bs : public prob_grad {
private:
    int SIZE;
    vector_d Y;
    vector_d VY;
    double VTAU;
    double VW;
    vector<double> VRANGE;
public:
    model_bs(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_bs(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_bs_namespace::model_bs";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("VY", "SIZE", SIZE);
        VY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        context__.validate_dims("data initialization", "VY", "vector_d", context__.to_vec(SIZE));
        vals_r__ = context__.vals_r("VY");
        pos__ = 0;
        size_t VY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < VY_i_vec_lim__; ++i_vec__) {
            VY[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "VTAU", "double", context__.to_vec());
        VTAU = double(0);
        vals_r__ = context__.vals_r("VTAU");
        pos__ = 0;
        VTAU = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VW", "double", context__.to_vec());
        VW = double(0);
        vals_r__ = context__.vals_r("VW");
        pos__ = 0;
        VW = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VRANGE", "double", context__.to_vec(2));
        validate_non_negative_index("VRANGE", "2", 2);
        VRANGE = std::vector<double>(2,double(0));
        vals_r__ = context__.vals_r("VRANGE");
        pos__ = 0;
        size_t VRANGE_limit_0__ = 2;
        for (size_t i_0__ = 0; i_0__ < VRANGE_limit_0__; ++i_0__) {
            VRANGE[i_0__] = vals_r__[pos__++];
        }

        // validate data
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"VTAU",VTAU,0);
        check_greater_or_equal(function__,"VW",VW,0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += SIZE;
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += SIZE;
    }

    ~model_bs() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("phi")))
            throw std::runtime_error("variable phi missing");
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("initialization", "phi", "vector_d", context__.to_vec(SIZE));
        vector_d phi(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            phi(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(phi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi: ") + e.what());
        }

        if (!(context__.contains_r("b0")))
            throw std::runtime_error("variable b0 missing");
        vals_r__ = context__.vals_r("b0");
        pos__ = 0U;
        context__.validate_dims("initialization", "b0", "double", context__.to_vec());
        double b0(0);
        b0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b0: ") + e.what());
        }

        if (!(context__.contains_r("omega")))
            throw std::runtime_error("variable omega missing");
        vals_r__ = context__.vals_r("omega");
        pos__ = 0U;
        context__.validate_dims("initialization", "omega", "double", context__.to_vec());
        double omega(0);
        omega = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,omega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable omega: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        context__.validate_dims("initialization", "uvs", "double", context__.to_vec(SIZE));
        std::vector<double> uvs(SIZE,double(0));
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            uvs[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            try {
            writer__.scalar_lub_unconstrain(0,1,uvs[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  phi;
        (void) phi;  // dummy to suppress unused var warning
        if (jacobian__)
            phi = in__.vector_constrain(SIZE,lp__);
        else
            phi = in__.vector_constrain(SIZE);

        T__ b0;
        (void) b0;  // dummy to suppress unused var warning
        if (jacobian__)
            b0 = in__.scalar_constrain(lp__);
        else
            b0 = in__.scalar_constrain();

        T__ omega;
        (void) omega;  // dummy to suppress unused var warning
        if (jacobian__)
            omega = in__.scalar_lb_constrain(0,lp__);
        else
            omega = in__.scalar_lb_constrain(0);

        vector<T__> uvs;
        size_t dim_uvs_0__ = SIZE;
        uvs.reserve(dim_uvs_0__);
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            if (jacobian__)
                uvs.push_back(in__.scalar_lub_constrain(0,1,lp__));
            else
                uvs.push_back(in__.scalar_lub_constrain(0,1));
        }


        // transformed parameters
        vector<T__> vs(SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(vs,DUMMY_VAR__);
        stan::math::fill(range,DUMMY_VAR__);

        try {
            current_statement_begin__ = 33;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 34;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 35;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 36;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < 2; ++i0__) {
            if (stan::math::is_uninitialized(range(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: range" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // model body
        try {
            current_statement_begin__ = 41;
            lp_accum__.add(normal_log<propto__>(b0, 0, sqrt(VTAU)));
            current_statement_begin__ = 42;
            lp_accum__.add(normal_log<propto__>(phi, 0, sqrt(omega)));
            current_statement_begin__ = 43;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 45;
            if (as_bool(logical_eq(0,VW))) {
                current_statement_begin__ = 47;
                lp_accum__.add(-(log(omega)));
            } else {
                current_statement_begin__ = 50;
                lp_accum__.add(normal_log<propto__>(omega, 0, sqrt(VW)));
            }
            current_statement_begin__ = 53;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 54;
                lp_accum__.add(normal_log<propto__>(get_base1(Y,i,"Y",1), (b0 + get_base1(phi,i,"phi",1)), sqrt(get_base1(vs,i,"vs",1))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("phi");
        names__.push_back("b0");
        names__.push_back("omega");
        names__.push_back("uvs");
        names__.push_back("vs");
        names__.push_back("range");
        names__.push_back("mu");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_bs_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d phi = in__.vector_constrain(SIZE);
        double b0 = in__.scalar_constrain();
        double omega = in__.scalar_lb_constrain(0);
        vector<double> uvs;
        size_t dim_uvs_0__ = SIZE;
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            uvs.push_back(in__.scalar_lub_constrain(0,1));
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(phi[k_0__]);
        }
        vars__.push_back(b0);
        vars__.push_back(omega);
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> vs(SIZE, 0.0);
        vector_d range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 33;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 34;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 35;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 36;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(range[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<double> mu(SIZE, 0.0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(mu,DUMMY_VAR__);

        try {
            current_statement_begin__ = 60;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 61;
                stan::math::assign(get_base1_lhs(mu,i,"mu",1), (b0 + get_base1(phi,i,"phi",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_bs";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.12

#include <stan/model/model_header.hpp>

namespace model_ds_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_ds : public prob_grad {
private:
    int SIZE;
    int NX;
    vector_d Y;
    vector_d VY;
    matrix_d X;
    double VTAU;
    double VW;
    vector<double> VRANGE;
public:
    model_ds(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_ds(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_ds_namespace::model_ds";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        context__.validate_dims("data initialization", "NX", "int", context__.to_vec());
        NX = int(0);
        vals_i__ = context__.vals_i("NX");
        pos__ = 0;
        NX = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("VY", "SIZE", SIZE);
        VY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        context__.validate_dims("data initialization", "VY", "vector_d", context__.to_vec(SIZE));
        vals_r__ = context__.vals_r("VY");
        pos__ = 0;
        size_t VY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < VY_i_vec_lim__; ++i_vec__) {
            VY[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(SIZE,NX));
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        X = matrix_d(static_cast<Eigen::VectorXd::Index>(SIZE),static_cast<Eigen::VectorXd::Index>(NX));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = SIZE;
        size_t X_n_mat_lim__ = NX;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                X(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "VTAU", "double", context__.to_vec());
        VTAU = double(0);
        vals_r__ = context__.vals_r("VTAU");
        pos__ = 0;
        VTAU = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VW", "double", context__.to_vec());
        VW = double(0);
        vals_r__ = context__.vals_r("VW");
        pos__ = 0;
        VW = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VRANGE", "double", context__.to_vec(2));
        validate_non_negative_index("VRANGE", "2", 2);
        VRANGE = std::vector<double>(2,double(0));
        vals_r__ = context__.vals_r("VRANGE");
        pos__ = 0;
        size_t VRANGE_limit_0__ = 2;
        for (size_t i_0__ = 0; i_0__ < VRANGE_limit_0__; ++i_0__) {
            VRANGE[i_0__] = vals_r__[pos__++];
        }

        // validate data
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"NX",NX,0);
        check_greater_or_equal(function__,"VTAU",VTAU,0);
        check_greater_or_equal(function__,"VW",VW,0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += NX;
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += SIZE;
    }

    ~model_ds() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "vector_d", context__.to_vec(NX));
        vector_d beta(static_cast<Eigen::VectorXd::Index>(NX));
        for (int j1__ = 0U; j1__ < NX; ++j1__)
            beta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        if (!(context__.contains_r("b0")))
            throw std::runtime_error("variable b0 missing");
        vals_r__ = context__.vals_r("b0");
        pos__ = 0U;
        context__.validate_dims("initialization", "b0", "double", context__.to_vec());
        double b0(0);
        b0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b0: ") + e.what());
        }

        if (!(context__.contains_r("omega")))
            throw std::runtime_error("variable omega missing");
        vals_r__ = context__.vals_r("omega");
        pos__ = 0U;
        context__.validate_dims("initialization", "omega", "double", context__.to_vec());
        double omega(0);
        omega = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,omega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable omega: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        context__.validate_dims("initialization", "uvs", "double", context__.to_vec(SIZE));
        std::vector<double> uvs(SIZE,double(0));
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            uvs[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            try {
            writer__.scalar_lub_unconstrain(0,1,uvs[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta;
        (void) beta;  // dummy to suppress unused var warning
        if (jacobian__)
            beta = in__.vector_constrain(NX,lp__);
        else
            beta = in__.vector_constrain(NX);

        T__ b0;
        (void) b0;  // dummy to suppress unused var warning
        if (jacobian__)
            b0 = in__.scalar_constrain(lp__);
        else
            b0 = in__.scalar_constrain();

        T__ omega;
        (void) omega;  // dummy to suppress unused var warning
        if (jacobian__)
            omega = in__.scalar_lb_constrain(0,lp__);
        else
            omega = in__.scalar_lb_constrain(0);

        vector<T__> uvs;
        size_t dim_uvs_0__ = SIZE;
        uvs.reserve(dim_uvs_0__);
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            if (jacobian__)
                uvs.push_back(in__.scalar_lub_constrain(0,1,lp__));
            else
                uvs.push_back(in__.scalar_lub_constrain(0,1));
        }


        // transformed parameters
        vector<T__> vs(SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(vs,DUMMY_VAR__);
        stan::math::fill(range,DUMMY_VAR__);

        try {
            current_statement_begin__ = 33;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 34;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 35;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 36;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < 2; ++i0__) {
            if (stan::math::is_uninitialized(range(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: range" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // model body
        try {
            current_statement_begin__ = 41;
            lp_accum__.add(normal_log<propto__>(b0, 0, sqrt(VTAU)));
            current_statement_begin__ = 42;
            lp_accum__.add(normal_log<propto__>(beta, 0, sqrt(omega)));
            current_statement_begin__ = 43;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 45;
            if (as_bool(logical_eq(0,VW))) {
                current_statement_begin__ = 46;
                lp_accum__.add(-(log(omega)));
            } else {
                current_statement_begin__ = 48;
                lp_accum__.add(normal_log<propto__>(omega, 0, sqrt(VW)));
            }
            current_statement_begin__ = 51;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 52;
                lp_accum__.add(normal_log<propto__>(get_base1(Y,i,"Y",1), (b0 + multiply(get_base1(X,i,"X",1),beta)), sqrt(get_base1(vs,i,"vs",1))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("b0");
        names__.push_back("omega");
        names__.push_back("uvs");
        names__.push_back("vs");
        names__.push_back("range");
        names__.push_back("mu");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(NX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_ds_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d beta = in__.vector_constrain(NX);
        double b0 = in__.scalar_constrain();
        double omega = in__.scalar_lb_constrain(0);
        vector<double> uvs;
        size_t dim_uvs_0__ = SIZE;
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            uvs.push_back(in__.scalar_lub_constrain(0,1));
        }
        for (int k_0__ = 0; k_0__ < NX; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }
        vars__.push_back(b0);
        vars__.push_back(omega);
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> vs(SIZE, 0.0);
        vector_d range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 33;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 34;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 35;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 36;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(range[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<double> mu(SIZE, 0.0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(mu,DUMMY_VAR__);

        try {
            current_statement_begin__ = 58;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 59;
                stan::math::assign(get_base1_lhs(mu,i,"mu",1), (b0 + multiply(get_base1(X,i,"X",1),beta)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ds";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.12

#include <stan/model/model_header.hpp>

namespace model_eds_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_eds : public prob_grad {
private:
    int SIZE;
    int NX;
    int NTAU;
    vector_d Y;
    vector_d VY;
    matrix_d X;
    vector<int> TAUINX;
    double VTAU;
    double VW;
    vector<double> VRANGE;
public:
    model_eds(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_eds(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_eds_namespace::model_eds";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        context__.validate_dims("data initialization", "NX", "int", context__.to_vec());
        NX = int(0);
        vals_i__ = context__.vals_i("NX");
        pos__ = 0;
        NX = vals_i__[pos__++];
        context__.validate_dims("data initialization", "NTAU", "int", context__.to_vec());
        NTAU = int(0);
        vals_i__ = context__.vals_i("NTAU");
        pos__ = 0;
        NTAU = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("VY", "SIZE", SIZE);
        VY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        context__.validate_dims("data initialization", "VY", "vector_d", context__.to_vec(SIZE));
        vals_r__ = context__.vals_r("VY");
        pos__ = 0;
        size_t VY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < VY_i_vec_lim__; ++i_vec__) {
            VY[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(SIZE,NX));
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        X = matrix_d(static_cast<Eigen::VectorXd::Index>(SIZE),static_cast<Eigen::VectorXd::Index>(NX));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = SIZE;
        size_t X_n_mat_lim__ = NX;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                X(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "TAUINX", "int", context__.to_vec(NX));
        validate_non_negative_index("TAUINX", "NX", NX);
        TAUINX = std::vector<int>(NX,int(0));
        vals_i__ = context__.vals_i("TAUINX");
        pos__ = 0;
        size_t TAUINX_limit_0__ = NX;
        for (size_t i_0__ = 0; i_0__ < TAUINX_limit_0__; ++i_0__) {
            TAUINX[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "VTAU", "double", context__.to_vec());
        VTAU = double(0);
        vals_r__ = context__.vals_r("VTAU");
        pos__ = 0;
        VTAU = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VW", "double", context__.to_vec());
        VW = double(0);
        vals_r__ = context__.vals_r("VW");
        pos__ = 0;
        VW = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VRANGE", "double", context__.to_vec(2));
        validate_non_negative_index("VRANGE", "2", 2);
        VRANGE = std::vector<double>(2,double(0));
        vals_r__ = context__.vals_r("VRANGE");
        pos__ = 0;
        size_t VRANGE_limit_0__ = 2;
        for (size_t i_0__ = 0; i_0__ < VRANGE_limit_0__; ++i_0__) {
            VRANGE[i_0__] = vals_r__[pos__++];
        }

        // validate data
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"NX",NX,0);
        check_greater_or_equal(function__,"NTAU",NTAU,0);
        for (int k0__ = 0; k0__ < NX; ++k0__) {
            check_greater_or_equal(function__,"TAUINX[k0__]",TAUINX[k0__],0);
        }
        check_greater_or_equal(function__,"VTAU",VTAU,0);
        check_greater_or_equal(function__,"VW",VW,0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += NX;
        ++num_params_r__;
        num_params_r__ += NTAU;
        num_params_r__ += SIZE;
    }

    ~model_eds() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "vector_d", context__.to_vec(NX));
        vector_d beta(static_cast<Eigen::VectorXd::Index>(NX));
        for (int j1__ = 0U; j1__ < NX; ++j1__)
            beta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        if (!(context__.contains_r("b0")))
            throw std::runtime_error("variable b0 missing");
        vals_r__ = context__.vals_r("b0");
        pos__ = 0U;
        context__.validate_dims("initialization", "b0", "double", context__.to_vec());
        double b0(0);
        b0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b0: ") + e.what());
        }

        if (!(context__.contains_r("omega")))
            throw std::runtime_error("variable omega missing");
        vals_r__ = context__.vals_r("omega");
        pos__ = 0U;
        context__.validate_dims("initialization", "omega", "double", context__.to_vec(NTAU));
        std::vector<double> omega(NTAU,double(0));
        for (int i0__ = 0U; i0__ < NTAU; ++i0__)
            omega[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < NTAU; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,omega[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable omega: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        context__.validate_dims("initialization", "uvs", "double", context__.to_vec(SIZE));
        std::vector<double> uvs(SIZE,double(0));
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            uvs[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            try {
            writer__.scalar_lub_unconstrain(0,1,uvs[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta;
        (void) beta;  // dummy to suppress unused var warning
        if (jacobian__)
            beta = in__.vector_constrain(NX,lp__);
        else
            beta = in__.vector_constrain(NX);

        T__ b0;
        (void) b0;  // dummy to suppress unused var warning
        if (jacobian__)
            b0 = in__.scalar_constrain(lp__);
        else
            b0 = in__.scalar_constrain();

        vector<T__> omega;
        size_t dim_omega_0__ = NTAU;
        omega.reserve(dim_omega_0__);
        for (size_t k_0__ = 0; k_0__ < dim_omega_0__; ++k_0__) {
            if (jacobian__)
                omega.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                omega.push_back(in__.scalar_lb_constrain(0));
        }

        vector<T__> uvs;
        size_t dim_uvs_0__ = SIZE;
        uvs.reserve(dim_uvs_0__);
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            if (jacobian__)
                uvs.push_back(in__.scalar_lub_constrain(0,1,lp__));
            else
                uvs.push_back(in__.scalar_lub_constrain(0,1));
        }


        // transformed parameters
        vector<T__> vs(SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(vs,DUMMY_VAR__);
        stan::math::fill(range,DUMMY_VAR__);

        try {
            current_statement_begin__ = 39;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 40;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 41;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 42;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < 2; ++i0__) {
            if (stan::math::is_uninitialized(range(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: range" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // model body
        try {
            current_statement_begin__ = 47;
            lp_accum__.add(normal_log<propto__>(b0, 0, sqrt(VTAU)));
            current_statement_begin__ = 48;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 50;
            if (as_bool(logical_eq(0,VW))) {
                current_statement_begin__ = 52;
                for (int i = 1; i <= NTAU; ++i) {
                    current_statement_begin__ = 53;
                    lp_accum__.add(-(log(get_base1(omega,i,"omega",1))));
                }
            } else {
                current_statement_begin__ = 57;
                lp_accum__.add(normal_log<propto__>(omega, 0, sqrt(VW)));
            }
            current_statement_begin__ = 61;
            for (int i = 1; i <= NX; ++i) {
                current_statement_begin__ = 62;
                lp_accum__.add(normal_log<propto__>(get_base1(beta,i,"beta",1), 0, sqrt(get_base1(omega,get_base1(TAUINX,i,"TAUINX",1),"omega",1))));
            }
            current_statement_begin__ = 64;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 65;
                lp_accum__.add(normal_log<propto__>(get_base1(Y,i,"Y",1), (b0 + multiply(get_base1(X,i,"X",1),beta)), sqrt(get_base1(vs,i,"vs",1))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("b0");
        names__.push_back("omega");
        names__.push_back("uvs");
        names__.push_back("vs");
        names__.push_back("range");
        names__.push_back("mu");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(NX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NTAU);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_eds_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d beta = in__.vector_constrain(NX);
        double b0 = in__.scalar_constrain();
        vector<double> omega;
        size_t dim_omega_0__ = NTAU;
        for (size_t k_0__ = 0; k_0__ < dim_omega_0__; ++k_0__) {
            omega.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> uvs;
        size_t dim_uvs_0__ = SIZE;
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            uvs.push_back(in__.scalar_lub_constrain(0,1));
        }
        for (int k_0__ = 0; k_0__ < NX; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }
        vars__.push_back(b0);
        for (int k_0__ = 0; k_0__ < NTAU; ++k_0__) {
            vars__.push_back(omega[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> vs(SIZE, 0.0);
        vector_d range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 39;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 40;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 41;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 42;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(range[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<double> mu(SIZE, 0.0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(mu,DUMMY_VAR__);

        try {
            current_statement_begin__ = 71;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 72;
                stan::math::assign(get_base1_lhs(mu,i,"mu",1), (b0 + multiply(get_base1(X,i,"X",1),beta)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_eds";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NTAU; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NTAU; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.12

#include <stan/model/model_header.hpp>

namespace model_fs_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_fs : public prob_grad {
private:
    int SIZE;
    vector<double> Y;
    vector<double> VY;
    double VTAU;
    vector<double> VRANGE;
public:
    model_fs(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_fs(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_fs_namespace::model_fs";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Y", "double", context__.to_vec(SIZE));
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = std::vector<double>(SIZE,double(0));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_limit_0__ = SIZE;
        for (size_t i_0__ = 0; i_0__ < Y_limit_0__; ++i_0__) {
            Y[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "VY", "double", context__.to_vec(SIZE));
        validate_non_negative_index("VY", "SIZE", SIZE);
        VY = std::vector<double>(SIZE,double(0));
        vals_r__ = context__.vals_r("VY");
        pos__ = 0;
        size_t VY_limit_0__ = SIZE;
        for (size_t i_0__ = 0; i_0__ < VY_limit_0__; ++i_0__) {
            VY[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "VTAU", "double", context__.to_vec());
        VTAU = double(0);
        vals_r__ = context__.vals_r("VTAU");
        pos__ = 0;
        VTAU = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VRANGE", "double", context__.to_vec(2));
        validate_non_negative_index("VRANGE", "2", 2);
        VRANGE = std::vector<double>(2,double(0));
        vals_r__ = context__.vals_r("VRANGE");
        pos__ = 0;
        size_t VRANGE_limit_0__ = 2;
        for (size_t i_0__ = 0; i_0__ < VRANGE_limit_0__; ++i_0__) {
            VRANGE[i_0__] = vals_r__[pos__++];
        }

        // validate data
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"VTAU",VTAU,0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += SIZE;
        num_params_r__ += SIZE;
    }

    ~model_fs() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "vector_d", context__.to_vec(SIZE));
        vector_d mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            mu(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        context__.validate_dims("initialization", "uvs", "double", context__.to_vec(SIZE));
        std::vector<double> uvs(SIZE,double(0));
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            uvs[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            try {
            writer__.scalar_lub_unconstrain(0,1,uvs[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu;
        (void) mu;  // dummy to suppress unused var warning
        if (jacobian__)
            mu = in__.vector_constrain(SIZE,lp__);
        else
            mu = in__.vector_constrain(SIZE);

        vector<T__> uvs;
        size_t dim_uvs_0__ = SIZE;
        uvs.reserve(dim_uvs_0__);
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            if (jacobian__)
                uvs.push_back(in__.scalar_lub_constrain(0,1,lp__));
            else
                uvs.push_back(in__.scalar_lub_constrain(0,1));
        }


        // transformed parameters
        vector<T__> vs(SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(vs,DUMMY_VAR__);
        stan::math::fill(range,DUMMY_VAR__);

        try {
            current_statement_begin__ = 26;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 28;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 29;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < 2; ++i0__) {
            if (stan::math::is_uninitialized(range(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: range" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // model body
        try {
            current_statement_begin__ = 34;
            lp_accum__.add(normal_log<propto__>(mu, 0, sqrt(VTAU)));
            current_statement_begin__ = 35;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 36;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 37;
                lp_accum__.add(normal_log<propto__>(get_base1(Y,i,"Y",1), get_base1(mu,i,"mu",1), sqrt(get_base1(vs,i,"vs",1))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu");
        names__.push_back("uvs");
        names__.push_back("vs");
        names__.push_back("range");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_fs_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu = in__.vector_constrain(SIZE);
        vector<double> uvs;
        size_t dim_uvs_0__ = SIZE;
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            uvs.push_back(in__.scalar_lub_constrain(0,1));
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> vs(SIZE, 0.0);
        vector_d range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 26;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 28;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 29;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(range[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_fs";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

} // namespace




// Code generated by Stan version 2.12

#include <stan/model/model_header.hpp>

namespace model_nse_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_nse : public prob_grad {
private:
    int SIZE;
    vector<double> Y;
    vector<double> VY;
    double VTAU;
    vector<double> VRANGE;
public:
    model_nse(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_nse(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_nse_namespace::model_nse";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Y", "double", context__.to_vec(SIZE));
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = std::vector<double>(SIZE,double(0));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_limit_0__ = SIZE;
        for (size_t i_0__ = 0; i_0__ < Y_limit_0__; ++i_0__) {
            Y[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "VY", "double", context__.to_vec(SIZE));
        validate_non_negative_index("VY", "SIZE", SIZE);
        VY = std::vector<double>(SIZE,double(0));
        vals_r__ = context__.vals_r("VY");
        pos__ = 0;
        size_t VY_limit_0__ = SIZE;
        for (size_t i_0__ = 0; i_0__ < VY_limit_0__; ++i_0__) {
            VY[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "VTAU", "double", context__.to_vec());
        VTAU = double(0);
        vals_r__ = context__.vals_r("VTAU");
        pos__ = 0;
        VTAU = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VRANGE", "double", context__.to_vec(2));
        validate_non_negative_index("VRANGE", "2", 2);
        VRANGE = std::vector<double>(2,double(0));
        vals_r__ = context__.vals_r("VRANGE");
        pos__ = 0;
        size_t VRANGE_limit_0__ = 2;
        for (size_t i_0__ = 0; i_0__ < VRANGE_limit_0__; ++i_0__) {
            VRANGE[i_0__] = vals_r__[pos__++];
        }

        // validate data
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"VTAU",VTAU,0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        num_params_r__ += SIZE;
    }

    ~model_nse() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "double", context__.to_vec());
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        context__.validate_dims("initialization", "uvs", "double", context__.to_vec(SIZE));
        std::vector<double> uvs(SIZE,double(0));
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            uvs[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            try {
            writer__.scalar_lub_unconstrain(0,1,uvs[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ tau;
        (void) tau;  // dummy to suppress unused var warning
        if (jacobian__)
            tau = in__.scalar_constrain(lp__);
        else
            tau = in__.scalar_constrain();

        vector<T__> uvs;
        size_t dim_uvs_0__ = SIZE;
        uvs.reserve(dim_uvs_0__);
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            if (jacobian__)
                uvs.push_back(in__.scalar_lub_constrain(0,1,lp__));
            else
                uvs.push_back(in__.scalar_lub_constrain(0,1));
        }


        // transformed parameters
        vector<T__> vs(SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(vs,DUMMY_VAR__);
        stan::math::fill(range,DUMMY_VAR__);

        try {
            current_statement_begin__ = 26;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 28;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 29;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < 2; ++i0__) {
            if (stan::math::is_uninitialized(range(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: range" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // model body
        try {
            current_statement_begin__ = 34;
            lp_accum__.add(normal_log<propto__>(tau, 0, sqrt(VTAU)));
            current_statement_begin__ = 35;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 36;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 37;
                lp_accum__.add(normal_log<propto__>(get_base1(Y,i,"Y",1), tau, sqrt(get_base1(vs,i,"vs",1))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("tau");
        names__.push_back("uvs");
        names__.push_back("vs");
        names__.push_back("range");
        names__.push_back("mu");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_nse_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double tau = in__.scalar_constrain();
        vector<double> uvs;
        size_t dim_uvs_0__ = SIZE;
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            uvs.push_back(in__.scalar_lub_constrain(0,1));
        }
        vars__.push_back(tau);
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> vs(SIZE, 0.0);
        vector_d range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 26;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 28;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 29;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(range[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<double> mu(SIZE, 0.0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(mu,DUMMY_VAR__);

        try {
            current_statement_begin__ = 43;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 44;
                stan::math::assign(get_base1_lhs(mu,i,"mu",1), tau);
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_nse";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.12

#include <stan/model/model_header.hpp>

namespace model_sr_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_sr : public prob_grad {
private:
    int SIZE;
    int NX;
    vector_d Y;
    vector_d VY;
    matrix_d X;
    double VTAU;
    double VGAMMA;
    vector<double> VRANGE;
public:
    model_sr(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_sr(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_sr_namespace::model_sr";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        context__.validate_dims("data initialization", "NX", "int", context__.to_vec());
        NX = int(0);
        vals_i__ = context__.vals_i("NX");
        pos__ = 0;
        NX = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("VY", "SIZE", SIZE);
        VY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        context__.validate_dims("data initialization", "VY", "vector_d", context__.to_vec(SIZE));
        vals_r__ = context__.vals_r("VY");
        pos__ = 0;
        size_t VY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < VY_i_vec_lim__; ++i_vec__) {
            VY[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(SIZE,NX));
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        X = matrix_d(static_cast<Eigen::VectorXd::Index>(SIZE),static_cast<Eigen::VectorXd::Index>(NX));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = SIZE;
        size_t X_n_mat_lim__ = NX;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                X(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "VTAU", "double", context__.to_vec());
        VTAU = double(0);
        vals_r__ = context__.vals_r("VTAU");
        pos__ = 0;
        VTAU = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VGAMMA", "double", context__.to_vec());
        VGAMMA = double(0);
        vals_r__ = context__.vals_r("VGAMMA");
        pos__ = 0;
        VGAMMA = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VRANGE", "double", context__.to_vec(2));
        validate_non_negative_index("VRANGE", "2", 2);
        VRANGE = std::vector<double>(2,double(0));
        vals_r__ = context__.vals_r("VRANGE");
        pos__ = 0;
        size_t VRANGE_limit_0__ = 2;
        for (size_t i_0__ = 0; i_0__ < VRANGE_limit_0__; ++i_0__) {
            VRANGE[i_0__] = vals_r__[pos__++];
        }

        // validate data
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"NX",NX,0);
        check_greater_or_equal(function__,"VTAU",VTAU,0);
        check_greater_or_equal(function__,"VGAMMA",VGAMMA,0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        num_params_r__ += NX;
        num_params_r__ += SIZE;
    }

    ~model_sr() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("b0")))
            throw std::runtime_error("variable b0 missing");
        vals_r__ = context__.vals_r("b0");
        pos__ = 0U;
        context__.validate_dims("initialization", "b0", "double", context__.to_vec());
        double b0(0);
        b0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b0: ") + e.what());
        }

        if (!(context__.contains_r("bgamma")))
            throw std::runtime_error("variable bgamma missing");
        vals_r__ = context__.vals_r("bgamma");
        pos__ = 0U;
        context__.validate_dims("initialization", "bgamma", "vector_d", context__.to_vec(NX));
        vector_d bgamma(static_cast<Eigen::VectorXd::Index>(NX));
        for (int j1__ = 0U; j1__ < NX; ++j1__)
            bgamma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(bgamma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable bgamma: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        context__.validate_dims("initialization", "uvs", "double", context__.to_vec(SIZE));
        std::vector<double> uvs(SIZE,double(0));
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            uvs[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            try {
            writer__.scalar_lub_unconstrain(0,1,uvs[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ b0;
        (void) b0;  // dummy to suppress unused var warning
        if (jacobian__)
            b0 = in__.scalar_constrain(lp__);
        else
            b0 = in__.scalar_constrain();

        Eigen::Matrix<T__,Eigen::Dynamic,1>  bgamma;
        (void) bgamma;  // dummy to suppress unused var warning
        if (jacobian__)
            bgamma = in__.vector_constrain(NX,lp__);
        else
            bgamma = in__.vector_constrain(NX);

        vector<T__> uvs;
        size_t dim_uvs_0__ = SIZE;
        uvs.reserve(dim_uvs_0__);
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            if (jacobian__)
                uvs.push_back(in__.scalar_lub_constrain(0,1,lp__));
            else
                uvs.push_back(in__.scalar_lub_constrain(0,1));
        }


        // transformed parameters
        vector<T__> vs(SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(vs,DUMMY_VAR__);
        stan::math::fill(range,DUMMY_VAR__);

        try {
            current_statement_begin__ = 32;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 33;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 34;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 35;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
                current_statement_begin__ = 36;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), sqrt(get_base1(vs,i,"vs",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < 2; ++i0__) {
            if (stan::math::is_uninitialized(range(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: range" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // model body
        try {
            current_statement_begin__ = 41;
            lp_accum__.add(normal_log<propto__>(b0, 0, sqrt(VTAU)));
            current_statement_begin__ = 42;
            lp_accum__.add(normal_log<propto__>(bgamma, 0, sqrt(VGAMMA)));
            current_statement_begin__ = 43;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 44;
            lp_accum__.add(normal_log<propto__>(Y, add(b0,multiply(X,bgamma)), vs));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("b0");
        names__.push_back("bgamma");
        names__.push_back("uvs");
        names__.push_back("vs");
        names__.push_back("range");
        names__.push_back("mu");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_sr_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double b0 = in__.scalar_constrain();
        vector_d bgamma = in__.vector_constrain(NX);
        vector<double> uvs;
        size_t dim_uvs_0__ = SIZE;
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            uvs.push_back(in__.scalar_lub_constrain(0,1));
        }
        vars__.push_back(b0);
        for (int k_0__ = 0; k_0__ < NX; ++k_0__) {
            vars__.push_back(bgamma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> vs(SIZE, 0.0);
        vector_d range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 32;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 33;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 34;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 35;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
                current_statement_begin__ = 36;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), sqrt(get_base1(vs,i,"vs",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(range[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<double> mu(SIZE, 0.0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(mu,DUMMY_VAR__);

        try {
            current_statement_begin__ = 49;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 50;
                stan::math::assign(get_base1_lhs(mu,i,"mu",1), (b0 + multiply(get_base1(X,i,"X",1),bgamma)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_sr";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.12

#include <stan/model/model_header.hpp>

namespace model_srs_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_srs : public prob_grad {
private:
    int SIZE;
    int NX;
    vector_d Y;
    vector_d VY;
    matrix_d X;
    double VTAU;
    double VW;
    double VGAMMA;
    vector<double> VRANGE;
public:
    model_srs(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_srs(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_srs_namespace::model_srs";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        context__.validate_dims("data initialization", "NX", "int", context__.to_vec());
        NX = int(0);
        vals_i__ = context__.vals_i("NX");
        pos__ = 0;
        NX = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("VY", "SIZE", SIZE);
        VY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        context__.validate_dims("data initialization", "VY", "vector_d", context__.to_vec(SIZE));
        vals_r__ = context__.vals_r("VY");
        pos__ = 0;
        size_t VY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < VY_i_vec_lim__; ++i_vec__) {
            VY[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(SIZE,NX));
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        X = matrix_d(static_cast<Eigen::VectorXd::Index>(SIZE),static_cast<Eigen::VectorXd::Index>(NX));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = SIZE;
        size_t X_n_mat_lim__ = NX;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                X(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "VTAU", "double", context__.to_vec());
        VTAU = double(0);
        vals_r__ = context__.vals_r("VTAU");
        pos__ = 0;
        VTAU = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VW", "double", context__.to_vec());
        VW = double(0);
        vals_r__ = context__.vals_r("VW");
        pos__ = 0;
        VW = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VGAMMA", "double", context__.to_vec());
        VGAMMA = double(0);
        vals_r__ = context__.vals_r("VGAMMA");
        pos__ = 0;
        VGAMMA = vals_r__[pos__++];
        context__.validate_dims("data initialization", "VRANGE", "double", context__.to_vec(2));
        validate_non_negative_index("VRANGE", "2", 2);
        VRANGE = std::vector<double>(2,double(0));
        vals_r__ = context__.vals_r("VRANGE");
        pos__ = 0;
        size_t VRANGE_limit_0__ = 2;
        for (size_t i_0__ = 0; i_0__ < VRANGE_limit_0__; ++i_0__) {
            VRANGE[i_0__] = vals_r__[pos__++];
        }

        // validate data
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"NX",NX,0);
        check_greater_or_equal(function__,"VTAU",VTAU,0);
        check_greater_or_equal(function__,"VW",VW,0);
        check_greater_or_equal(function__,"VGAMMA",VGAMMA,0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += SIZE;
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += NX;
        num_params_r__ += SIZE;
    }

    ~model_srs() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("phi")))
            throw std::runtime_error("variable phi missing");
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("initialization", "phi", "vector_d", context__.to_vec(SIZE));
        vector_d phi(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            phi(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(phi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi: ") + e.what());
        }

        if (!(context__.contains_r("omega")))
            throw std::runtime_error("variable omega missing");
        vals_r__ = context__.vals_r("omega");
        pos__ = 0U;
        context__.validate_dims("initialization", "omega", "double", context__.to_vec());
        double omega(0);
        omega = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,omega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable omega: ") + e.what());
        }

        if (!(context__.contains_r("b0")))
            throw std::runtime_error("variable b0 missing");
        vals_r__ = context__.vals_r("b0");
        pos__ = 0U;
        context__.validate_dims("initialization", "b0", "double", context__.to_vec());
        double b0(0);
        b0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b0: ") + e.what());
        }

        if (!(context__.contains_r("bgamma")))
            throw std::runtime_error("variable bgamma missing");
        vals_r__ = context__.vals_r("bgamma");
        pos__ = 0U;
        context__.validate_dims("initialization", "bgamma", "vector_d", context__.to_vec(NX));
        vector_d bgamma(static_cast<Eigen::VectorXd::Index>(NX));
        for (int j1__ = 0U; j1__ < NX; ++j1__)
            bgamma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(bgamma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable bgamma: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        context__.validate_dims("initialization", "uvs", "double", context__.to_vec(SIZE));
        std::vector<double> uvs(SIZE,double(0));
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            uvs[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < SIZE; ++i0__)
            try {
            writer__.scalar_lub_unconstrain(0,1,uvs[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  phi;
        (void) phi;  // dummy to suppress unused var warning
        if (jacobian__)
            phi = in__.vector_constrain(SIZE,lp__);
        else
            phi = in__.vector_constrain(SIZE);

        T__ omega;
        (void) omega;  // dummy to suppress unused var warning
        if (jacobian__)
            omega = in__.scalar_lb_constrain(0,lp__);
        else
            omega = in__.scalar_lb_constrain(0);

        T__ b0;
        (void) b0;  // dummy to suppress unused var warning
        if (jacobian__)
            b0 = in__.scalar_constrain(lp__);
        else
            b0 = in__.scalar_constrain();

        Eigen::Matrix<T__,Eigen::Dynamic,1>  bgamma;
        (void) bgamma;  // dummy to suppress unused var warning
        if (jacobian__)
            bgamma = in__.vector_constrain(NX,lp__);
        else
            bgamma = in__.vector_constrain(NX);

        vector<T__> uvs;
        size_t dim_uvs_0__ = SIZE;
        uvs.reserve(dim_uvs_0__);
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            if (jacobian__)
                uvs.push_back(in__.scalar_lub_constrain(0,1,lp__));
            else
                uvs.push_back(in__.scalar_lub_constrain(0,1));
        }


        // transformed parameters
        vector<T__> vs(SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(vs,DUMMY_VAR__);
        stan::math::fill(range,DUMMY_VAR__);

        try {
            current_statement_begin__ = 35;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 36;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 37;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 38;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < 2; ++i0__) {
            if (stan::math::is_uninitialized(range(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: range" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // model body
        try {
            current_statement_begin__ = 44;
            lp_accum__.add(normal_log<propto__>(phi, 0, sqrt(omega)));
            current_statement_begin__ = 45;
            lp_accum__.add(normal_log<propto__>(b0, 0, sqrt(VTAU)));
            current_statement_begin__ = 46;
            lp_accum__.add(normal_log<propto__>(bgamma, 0, sqrt(VGAMMA)));
            current_statement_begin__ = 47;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 49;
            if (as_bool(logical_eq(0,VW))) {
                current_statement_begin__ = 51;
                lp_accum__.add(-(log(omega)));
            } else {
                current_statement_begin__ = 54;
                lp_accum__.add(normal_log<propto__>(omega, 0, sqrt(VW)));
            }
            current_statement_begin__ = 57;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 58;
                lp_accum__.add(normal_log<propto__>(get_base1(Y,i,"Y",1), ((b0 + multiply(get_base1(X,i,"X",1),bgamma)) + get_base1(phi,i,"phi",1)), sqrt(get_base1(vs,i,"vs",1))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("phi");
        names__.push_back("omega");
        names__.push_back("b0");
        names__.push_back("bgamma");
        names__.push_back("uvs");
        names__.push_back("vs");
        names__.push_back("range");
        names__.push_back("mu");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_srs_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d phi = in__.vector_constrain(SIZE);
        double omega = in__.scalar_lb_constrain(0);
        double b0 = in__.scalar_constrain();
        vector_d bgamma = in__.vector_constrain(NX);
        vector<double> uvs;
        size_t dim_uvs_0__ = SIZE;
        for (size_t k_0__ = 0; k_0__ < dim_uvs_0__; ++k_0__) {
            uvs.push_back(in__.scalar_lub_constrain(0,1));
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(phi[k_0__]);
        }
        vars__.push_back(omega);
        vars__.push_back(b0);
        for (int k_0__ = 0; k_0__ < NX; ++k_0__) {
            vars__.push_back(bgamma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> vs(SIZE, 0.0);
        vector_d range(static_cast<Eigen::VectorXd::Index>(2));
        (void) range;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 35;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 36;
                stan::math::assign(get_base1_lhs(range,1,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,1,"VRANGE",1)));
                current_statement_begin__ = 37;
                stan::math::assign(get_base1_lhs(range,2,"range",1), (log(get_base1(VY,i,"VY",1)) + get_base1(VRANGE,2,"VRANGE",1)));
                current_statement_begin__ = 38;
                stan::math::assign(get_base1_lhs(vs,i,"vs",1), exp((get_base1(range,1,"range",1) + (get_base1(uvs,i,"uvs",1) * (get_base1(range,2,"range",1) - get_base1(range,1,"range",1))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < SIZE; ++k0__) {
            check_greater_or_equal(function__,"vs[k0__]",vs[k0__],0);
        }

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(range[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<double> mu(SIZE, 0.0);

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(mu,DUMMY_VAR__);

        try {
            current_statement_begin__ = 64;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 65;
                stan::math::assign(get_base1_lhs(mu,i,"mu",1), ((b0 + multiply(get_base1(X,i,"X",1),bgamma)) + get_base1(phi,i,"phi",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_srs";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "range" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




#endif
