% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_default_beast2_download_url.R
\name{get_default_beast2_download_url}
\alias{get_default_beast2_download_url}
\title{Get the default BEAST2 download URL,
which depends on the operating system}
\usage{
get_default_beast2_download_url(os = rappdirs::app_dir()$os)
}
\arguments{
\item{os}{name of the operating system,
must be \code{unix} (Linux, Mac) or \code{win} (Windows)}
}
\value{
the URL where BEAST2 can be downloaded from
}
\description{
Get the default BEAST2 download URL,
which depends on the operating system
}
\examples{
  library(testthat)

  expect_true(
    grepl(
      "https://github.com/CompEvol/beast2/releases/download",
      get_default_beast2_download_url()
    )
  )

  if (rappdirs::app_dir()$os == "unix") {
    expect_true(
      grepl(
        "BEAST.v[0-9\\\\.]+.Linux.tgz",
        get_default_beast2_download_url()
      )
    )
  }
}
\author{
Richèl J.C. Bilderbeek
}
