% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continue_beast2.R
\name{continue_beast2}
\alias{continue_beast2}
\title{Continue a BEAST2 run}
\usage{
continue_beast2(beast2_options = create_beast2_options())
}
\arguments{
\item{beast2_options}{a set of BEAST2 options,
that are the R equivalent of the BEAST2 command-line options,
as can be created by \link{create_beast2_options}}
}
\value{
The text sent to \code{STDOUT} and \code{STDERR}.
  It will create the file with name \code{output_state_filenames}
}
\description{
Continue a BEAST2 run
}
\examples{
check_empty_beaustier_folders()

if (is_beast2_installed() && is_on_ci()) {
  beast2_options <- create_beast2_options(
    input_filename = get_beastier_path("2_4.xml")
  )
  run_beast2_from_options(beast2_options)
  continue_beast2(beast2_options)
  file.remove(beast2_options$output_state_filename)
  remove_beaustier_folders()
}

check_empty_beaustier_folders()
}
\author{
Richèl J.C. Bilderbeek
}
