% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_continue_cmd_from_options.R
\name{create_beast2_continue_cmd_from_options}
\alias{create_beast2_continue_cmd_from_options}
\title{Creates the terminal command to run BEAST2 from a \code{beast2_options}}
\usage{
create_beast2_continue_cmd_from_options(beast2_options)
}
\arguments{
\item{beast2_options}{a set of BEAST2 options,
that are the R equivalent of the BEAST2 command-line options,
as can be created by \link{create_beast2_options}}
}
\value{
a character vector with the command and
  arguments to call BEAST2
}
\description{
If the BEAST2 input \code{.xml} filename
or the BEAST2 state \code{.state.xml} filename
contain spaces, these filenames are quoted,
so that the command-line interface to BEAST2 correctly parses its arguments
}
\examples{
  if (is_beast2_installed()) {
    create_beast2_continue_cmd_from_options(
      beast2_options = create_beast2_options()
    )
  }
}
\author{
Richèl J.C. Bilderbeek
}
