% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_default_beast2_path.R
\name{get_default_beast2_path}
\alias{get_default_beast2_path}
\title{Get the default BEAST2 path}
\usage{
get_default_beast2_path(
  beast2_folder = get_default_beast2_folder(),
  os = rappdirs::app_dir()$os
)
}
\arguments{
\item{beast2_folder}{the folder where the BEAST2 is installed.
Note that this is not the folder where the BEAST2 executable
is installed: the BEAST2 executable is in a subfolder.
Use \link{get_default_beast2_folder} to get the default BEAST2
folder.
Use \link{get_default_beast2_bin_path} to get the full path to
the default BEAST2 executable.}

\item{os}{name of the operating system,
must be \code{unix} (Linux, Mac) or \code{win} (Windows)}
}
\value{
the default BEAST2 path
}
\description{
Get the default BEAST2 path
}
\examples{
if (is_beast2_installed()) {
  get_default_beast2_path()
}
}
\seealso{
Use \link{get_default_beast2_bin_path}
    to get the default path to the BEAST2 binary file.
  Use \link{get_default_beast2_jar_path}
    to get the default path to the BEAST2 jar file.
  Use \link{get_default_beast2_folder} to get the default
  folder in which BEAST2 is installed.
  Use \link{install_beast2} with default arguments
  to install BEAST2 to this location.
}
\author{
Richèl J.C. Bilderbeek
}
