% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ube.R
\name{read_ube}
\alias{read_ube}
\title{Read data from a UBE file}
\usage{
read_ube(ube_path)
}
\arguments{
\item{ube_path}{Path to UBE file.}
}
\value{
A data.frame with columns timestamp (POSIXct) and ecg (numeric)
}
\description{
\code{read_ube} parses a binary UBE file, returning a data frame with ECG
records and timestamps
}
\examples{
# File path to sample data
fp <- system.file("extdata", "max_ecg_190826b.ube", package = "beats")
# Read ube file
ecg_data <- read_ube(fp)
}
