% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_mrca_prior.R
\name{is_mrca_prior}
\alias{is_mrca_prior}
\title{Determine of the object is an empty (\code{NA}) or valid MRCA prior.}
\usage{
is_mrca_prior(mrca_prior)
}
\arguments{
\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}
}
\value{
TRUE if \code{x} is an MRCA prior, FALSE otherwise
}
\description{
Determine of the object is an empty (\code{NA}) or valid MRCA prior.
}
\examples{
library(testthat)

expect_true(is_mrca_prior(create_mrca_prior()))
# Also 'NA' is a valid MRCA prior,
# denoting that there no MRCA priors
expect_true(is_mrca_prior(NA))

expect_false(is_mrca_prior(NULL))
expect_false(is_mrca_prior("nonsense"))
}
\author{
Richèl J.C. Bilderbeek
}
