% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_m_param}
\alias{create_m_param}
\alias{create_param_m}
\title{Create a parameter called m}
\usage{
create_m_param(id = NA, value = 0)
}
\arguments{
\item{id}{the parameter's ID}

\item{value}{value of the parameter}
}
\value{
a parameter called m
}
\description{
Create a parameter called m
}
\note{
this parameter is used in a log-normal distribution
  (as returned by \code{\link{create_log_normal_distr}})
  It cannot be estimated (as a hyper parameter) yet.
}
\examples{
  # Create the parameter
  m_param <- create_m_param()

  # Use the parameter in a distribution
  log_normal_distr <- create_log_normal_distr(
    m = m_param
  )

  # Use the distribution to create a BEAST2 input file
  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    beast2_input_file,
    tree_prior = create_yule_tree_prior(
      birth_rate_distr = log_normal_distr
    )
  )
  testit::assert(file.exists(beast2_input_file))
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richèl J.C. Bilderbeek
}
