% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/belldist.R
\name{Bell}
\alias{Bell}
\alias{dbell}
\alias{pbell}
\alias{qbell}
\alias{rbell}
\title{Probability function, distribution function, quantile function and random generation for the Bell distribution with parameter theta.}
\usage{
dbell(x, theta, log = FALSE)

pbell(q, theta, lower.tail = TRUE, log.p = FALSE)

qbell(p, theta, log.p = FALSE)

rbell(n, theta)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{theta}{parameter of the Bell distribution (theta > 0).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}; otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of random values to return.}
}
\value{
dbell gives the (log) probability function, pbell gives the (log) distribution function, qbell gives the quantile function, and rbell generates random deviates.
}
\description{
Probability function, distribution function, quantile function and random generation for the Bell distribution with parameter theta.
}
\details{
Probability mass function
\deqn{
f(x) = \frac{\theta^{x} e^{1-e^{\theta}}B_x}{x!},
}
where \eqn{B_x} is the Bell number, and x = 0, 1, ....
}
\concept{Discrete}
\concept{Univariate}
\keyword{distribution}
