% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{confint.bellreg}
\alias{confint.bellreg}
\title{Confidence intervals for the regression coefficients}
\usage{
\method{confint}{bellreg}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{an object of the class bellreg}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required}

\item{...}{further arguments passed to or from other methods}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence limits for each parameter. These will be labelled as (1-level)/2 and 1 - (1-level)/2 in \\% (by default 2.5\\% and 97.5\\%).
}
\description{
Confidence intervals for the regression coefficients
}
\examples{
\donttest{
data(faults)
fit <- bellreg(nf ~ lroll, data = faults)
confint(fit)
}

}
