// Generated by rstantools.  Do not edit by hand.

/*
    bennu is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bennu is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bennu.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_distribution_covariate_model_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_distribution_covariate_model");
    reader.add_event(247, 245, "end", "model_distribution_covariate_model");
    return reader;
}
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& rev_pmf, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 17;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(x));
        current_statement_begin__ = 18;
        int max_pmf(0);
        (void) max_pmf;  // dummy to suppress unused var warning
        stan::math::fill(max_pmf, std::numeric_limits<int>::min());
        stan::math::assign(max_pmf,num_elements(rev_pmf));
        current_statement_begin__ = 19;
        validate_non_negative_index("conv_cases", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> conv_cases(t);
        stan::math::initialize(conv_cases, DUMMY_VAR__);
        stan::math::fill(conv_cases, DUMMY_VAR__);
        stan::math::assign(conv_cases,rep_vector(1e-5, t));
        current_statement_begin__ = 20;
        for (int s = 1; s <= t; ++s) {
            current_statement_begin__ = 21;
            stan::model::assign(conv_cases, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        (stan::model::rvalue(conv_cases, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "conv_cases") + dot_product(stan::model::rvalue(x, stan::model::cons_list(stan::model::index_min_max(std::max(1, ((s - max_pmf) + 1)), s), stan::model::nil_index_list()), "x"), tail(rev_pmf, std::min(max_pmf, s)))), 
                        "assigning variable conv_cases");
        }
        current_statement_begin__ = 24;
        return stan::math::promote_scalar<fun_return_scalar_t__>(conv_cases);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& rev_pmf, std::ostream* pstream__) const {
        return convolve(x, rev_pmf, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
rev_func(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 29;
        int n_points(0);
        (void) n_points;  // dummy to suppress unused var warning
        stan::math::fill(n_points, std::numeric_limits<int>::min());
        stan::math::assign(n_points,num_elements(x));
        current_statement_begin__ = 30;
        validate_non_negative_index("x_rev", "n_points", n_points);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x_rev(n_points);
        stan::math::initialize(x_rev, DUMMY_VAR__);
        stan::math::fill(x_rev, DUMMY_VAR__);
        current_statement_begin__ = 32;
        for (int i = 1; i <= n_points; ++i) {
            current_statement_begin__ = 33;
            stan::model::assign(x_rev, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        get_base1(x, ((n_points - i) + 1), "x", 1), 
                        "assigning variable x_rev");
        }
        current_statement_begin__ = 35;
        return stan::math::promote_scalar<fun_return_scalar_t__>(x_rev);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct rev_func_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) const {
        return rev_func(x, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
to_triangular_convolution(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                              const int& K, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 41;
        validate_non_negative_index("y", "K", K);
        validate_non_negative_index("y", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> y(K, K);
        stan::math::initialize(y, DUMMY_VAR__);
        stan::math::fill(y, DUMMY_VAR__);
        current_statement_begin__ = 42;
        int pos(0);
        (void) pos;  // dummy to suppress unused var warning
        stan::math::fill(pos, std::numeric_limits<int>::min());
        stan::math::assign(pos,1);
        current_statement_begin__ = 43;
        for (int i = 1; i <= K; ++i) {
            current_statement_begin__ = 44;
            for (int j = 1; j <= K; ++j) {
                current_statement_begin__ = 45;
                stan::math::assign(pos, ((i + 1) - j));
                current_statement_begin__ = 46;
                if (as_bool((primitive_value(logical_gt(pos, 0)) && primitive_value(logical_lte(pos, num_elements(x)))))) {
                    current_statement_begin__ = 47;
                    stan::model::assign(y, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                get_base1(x, pos, "x", 1), 
                                "assigning variable y");
                } else {
                    current_statement_begin__ = 49;
                    stan::model::assign(y, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable y");
                }
            }
        }
        current_statement_begin__ = 54;
        return stan::math::promote_scalar<fun_return_scalar_t__>(y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct to_triangular_convolution_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                              const int& K, std::ostream* pstream__) const {
        return to_triangular_convolution(x, K, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_distribution_covariate_model
  : public stan::model::model_base_crtp<model_distribution_covariate_model> {
private:
        int run_estimation;
        int rw_type;
        int N_region;
        int N_t;
        int N;
        int N_distributed;
        double alpha;
        double beta;
        int max_delays;
        int N_psi;
        std::vector<double> psi;
        std::vector<int> regions;
        std::vector<int> times;
        std::vector<int> Orders;
        std::vector<std::vector<int> > Orders2D;
        std::vector<int> Reported_Distributed;
        std::vector<int> Reported_Used;
        double mu0_sigma;
        double sigma_sigma;
        double mu0_mu;
        double sigma_mu;
        vector_d distribute_pmf;
        vector_d reverse_distribute_pmf;
        double trunc_pmf;
        matrix_d reporting_delay_matrix;
public:
    model_distribution_covariate_model(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_distribution_covariate_model(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_distribution_covariate_model_namespace::model_distribution_covariate_model";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 62;
            context__.validate_dims("data initialization", "run_estimation", "int", context__.to_vec());
            run_estimation = int(0);
            vals_i__ = context__.vals_i("run_estimation");
            pos__ = 0;
            run_estimation = vals_i__[pos__++];
            check_greater_or_equal(function__, "run_estimation", run_estimation, 0);
            check_less_or_equal(function__, "run_estimation", run_estimation, 1);
            current_statement_begin__ = 65;
            context__.validate_dims("data initialization", "rw_type", "int", context__.to_vec());
            rw_type = int(0);
            vals_i__ = context__.vals_i("rw_type");
            pos__ = 0;
            rw_type = vals_i__[pos__++];
            check_greater_or_equal(function__, "rw_type", rw_type, 1);
            check_less_or_equal(function__, "rw_type", rw_type, 2);
            current_statement_begin__ = 68;
            context__.validate_dims("data initialization", "N_region", "int", context__.to_vec());
            N_region = int(0);
            vals_i__ = context__.vals_i("N_region");
            pos__ = 0;
            N_region = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_region", N_region, 0);
            current_statement_begin__ = 71;
            context__.validate_dims("data initialization", "N_t", "int", context__.to_vec());
            N_t = int(0);
            vals_i__ = context__.vals_i("N_t");
            pos__ = 0;
            N_t = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_t", N_t, 0);
            current_statement_begin__ = 74;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 0);
            current_statement_begin__ = 77;
            context__.validate_dims("data initialization", "N_distributed", "int", context__.to_vec());
            N_distributed = int(0);
            vals_i__ = context__.vals_i("N_distributed");
            pos__ = 0;
            N_distributed = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_distributed", N_distributed, 0);
            current_statement_begin__ = 80;
            context__.validate_dims("data initialization", "alpha", "double", context__.to_vec());
            alpha = double(0);
            vals_r__ = context__.vals_r("alpha");
            pos__ = 0;
            alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "alpha", alpha, 0);
            current_statement_begin__ = 81;
            context__.validate_dims("data initialization", "beta", "double", context__.to_vec());
            beta = double(0);
            vals_r__ = context__.vals_r("beta");
            pos__ = 0;
            beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "beta", beta, 0);
            current_statement_begin__ = 84;
            context__.validate_dims("data initialization", "max_delays", "int", context__.to_vec());
            max_delays = int(0);
            vals_i__ = context__.vals_i("max_delays");
            pos__ = 0;
            max_delays = vals_i__[pos__++];
            check_greater_or_equal(function__, "max_delays", max_delays, 0);
            current_statement_begin__ = 87;
            context__.validate_dims("data initialization", "N_psi", "int", context__.to_vec());
            N_psi = int(0);
            vals_i__ = context__.vals_i("N_psi");
            pos__ = 0;
            N_psi = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_psi", N_psi, 0);
            current_statement_begin__ = 88;
            validate_non_negative_index("psi", "N_psi", N_psi);
            context__.validate_dims("data initialization", "psi", "double", context__.to_vec(N_psi));
            psi = std::vector<double>(N_psi, double(0));
            vals_r__ = context__.vals_r("psi");
            pos__ = 0;
            size_t psi_k_0_max__ = N_psi;
            for (size_t k_0__ = 0; k_0__ < psi_k_0_max__; ++k_0__) {
                psi[k_0__] = vals_r__[pos__++];
            }
            size_t psi_i_0_max__ = N_psi;
            for (size_t i_0__ = 0; i_0__ < psi_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "psi[i_0__]", psi[i_0__], 0);
            }
            current_statement_begin__ = 91;
            validate_non_negative_index("regions", "N_distributed", N_distributed);
            context__.validate_dims("data initialization", "regions", "int", context__.to_vec(N_distributed));
            regions = std::vector<int>(N_distributed, int(0));
            vals_i__ = context__.vals_i("regions");
            pos__ = 0;
            size_t regions_k_0_max__ = N_distributed;
            for (size_t k_0__ = 0; k_0__ < regions_k_0_max__; ++k_0__) {
                regions[k_0__] = vals_i__[pos__++];
            }
            size_t regions_i_0_max__ = N_distributed;
            for (size_t i_0__ = 0; i_0__ < regions_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "regions[i_0__]", regions[i_0__], 1);
                check_less_or_equal(function__, "regions[i_0__]", regions[i_0__], N_region);
            }
            current_statement_begin__ = 94;
            validate_non_negative_index("times", "N_distributed", N_distributed);
            context__.validate_dims("data initialization", "times", "int", context__.to_vec(N_distributed));
            times = std::vector<int>(N_distributed, int(0));
            vals_i__ = context__.vals_i("times");
            pos__ = 0;
            size_t times_k_0_max__ = N_distributed;
            for (size_t k_0__ = 0; k_0__ < times_k_0_max__; ++k_0__) {
                times[k_0__] = vals_i__[pos__++];
            }
            size_t times_i_0_max__ = N_distributed;
            for (size_t i_0__ = 0; i_0__ < times_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "times[i_0__]", times[i_0__], 1);
                check_less_or_equal(function__, "times[i_0__]", times[i_0__], N_t);
            }
            current_statement_begin__ = 97;
            validate_non_negative_index("Orders", "N", N);
            context__.validate_dims("data initialization", "Orders", "int", context__.to_vec(N));
            Orders = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("Orders");
            pos__ = 0;
            size_t Orders_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < Orders_k_0_max__; ++k_0__) {
                Orders[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 100;
            validate_non_negative_index("Orders2D", "N_region", N_region);
            validate_non_negative_index("Orders2D", "N_t", N_t);
            context__.validate_dims("data initialization", "Orders2D", "int", context__.to_vec(N_region,N_t));
            Orders2D = std::vector<std::vector<int> >(N_region, std::vector<int>(N_t, int(0)));
            vals_i__ = context__.vals_i("Orders2D");
            pos__ = 0;
            size_t Orders2D_k_0_max__ = N_region;
            size_t Orders2D_k_1_max__ = N_t;
            for (size_t k_1__ = 0; k_1__ < Orders2D_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < Orders2D_k_0_max__; ++k_0__) {
                    Orders2D[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 103;
            validate_non_negative_index("Reported_Distributed", "N_distributed", N_distributed);
            context__.validate_dims("data initialization", "Reported_Distributed", "int", context__.to_vec(N_distributed));
            Reported_Distributed = std::vector<int>(N_distributed, int(0));
            vals_i__ = context__.vals_i("Reported_Distributed");
            pos__ = 0;
            size_t Reported_Distributed_k_0_max__ = N_distributed;
            for (size_t k_0__ = 0; k_0__ < Reported_Distributed_k_0_max__; ++k_0__) {
                Reported_Distributed[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 106;
            validate_non_negative_index("Reported_Used", "N_distributed", N_distributed);
            context__.validate_dims("data initialization", "Reported_Used", "int", context__.to_vec(N_distributed));
            Reported_Used = std::vector<int>(N_distributed, int(0));
            vals_i__ = context__.vals_i("Reported_Used");
            pos__ = 0;
            size_t Reported_Used_k_0_max__ = N_distributed;
            for (size_t k_0__ = 0; k_0__ < Reported_Used_k_0_max__; ++k_0__) {
                Reported_Used[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 109;
            context__.validate_dims("data initialization", "mu0_sigma", "double", context__.to_vec());
            mu0_sigma = double(0);
            vals_r__ = context__.vals_r("mu0_sigma");
            pos__ = 0;
            mu0_sigma = vals_r__[pos__++];
            check_greater_or_equal(function__, "mu0_sigma", mu0_sigma, 0);
            current_statement_begin__ = 110;
            context__.validate_dims("data initialization", "sigma_sigma", "double", context__.to_vec());
            sigma_sigma = double(0);
            vals_r__ = context__.vals_r("sigma_sigma");
            pos__ = 0;
            sigma_sigma = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_sigma", sigma_sigma, 0);
            current_statement_begin__ = 111;
            context__.validate_dims("data initialization", "mu0_mu", "double", context__.to_vec());
            mu0_mu = double(0);
            vals_r__ = context__.vals_r("mu0_mu");
            pos__ = 0;
            mu0_mu = vals_r__[pos__++];
            current_statement_begin__ = 112;
            context__.validate_dims("data initialization", "sigma_mu", "double", context__.to_vec());
            sigma_mu = double(0);
            vals_r__ = context__.vals_r("sigma_mu");
            pos__ = 0;
            sigma_mu = vals_r__[pos__++];
            // initialize transformed data variables
            current_statement_begin__ = 118;
            validate_non_negative_index("distribute_pmf", "max_delays", max_delays);
            distribute_pmf = Eigen::Matrix<double, Eigen::Dynamic, 1>(max_delays);
            stan::math::fill(distribute_pmf, DUMMY_VAR__);
            current_statement_begin__ = 119;
            validate_non_negative_index("reverse_distribute_pmf", "max_delays", max_delays);
            reverse_distribute_pmf = Eigen::Matrix<double, Eigen::Dynamic, 1>(max_delays);
            stan::math::fill(reverse_distribute_pmf, DUMMY_VAR__);
            current_statement_begin__ = 120;
            trunc_pmf = double(0);
            stan::math::fill(trunc_pmf, DUMMY_VAR__);
            current_statement_begin__ = 121;
            validate_non_negative_index("reporting_delay_matrix", "N_t", N_t);
            validate_non_negative_index("reporting_delay_matrix", "N_t", N_t);
            reporting_delay_matrix = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N_t, N_t);
            stan::math::fill(reporting_delay_matrix, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 125;
            stan::math::assign(trunc_pmf, (gamma_cdf((max_delays + 1), alpha, beta) - gamma_cdf(1, alpha, beta)));
            current_statement_begin__ = 126;
            for (int i = 1; i <= max_delays; ++i) {
                current_statement_begin__ = 127;
                stan::model::assign(distribute_pmf, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((gamma_cdf((i + 1), alpha, beta) - gamma_cdf(i, alpha, beta)) / trunc_pmf), 
                            "assigning variable distribute_pmf");
            }
            current_statement_begin__ = 131;
            stan::math::assign(reverse_distribute_pmf, rev_func(distribute_pmf, pstream__));
            current_statement_begin__ = 134;
            stan::math::assign(reporting_delay_matrix, to_triangular_convolution(to_vector(psi), N_t, pstream__));
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 144;
            validate_non_negative_index("logp", "N_distributed", N_distributed);
            num_params_r__ += (1 * N_distributed);
            current_statement_begin__ = 145;
            num_params_r__ += 1;
            current_statement_begin__ = 146;
            num_params_r__ += 1;
            current_statement_begin__ = 147;
            num_params_r__ += 1;
            current_statement_begin__ = 149;
            validate_non_negative_index("c", "N_region", N_region);
            num_params_r__ += (1 * N_region);
            current_statement_begin__ = 150;
            validate_non_negative_index("ct", "N_t", N_t);
            num_params_r__ += (1 * N_t);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_distribution_covariate_model() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 144;
        if (!(context__.contains_r("logp")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable logp missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("logp");
        pos__ = 0U;
        validate_non_negative_index("logp", "N_distributed", N_distributed);
        context__.validate_dims("parameter initialization", "logp", "double", context__.to_vec(N_distributed));
        std::vector<double> logp(N_distributed, double(0));
        size_t logp_k_0_max__ = N_distributed;
        for (size_t k_0__ = 0; k_0__ < logp_k_0_max__; ++k_0__) {
            logp[k_0__] = vals_r__[pos__++];
        }
        size_t logp_i_0_max__ = N_distributed;
        for (size_t i_0__ = 0; i_0__ < logp_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(logp[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable logp: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 145;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 146;
        if (!(context__.contains_r("zeta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable zeta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("zeta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "zeta", "double", context__.to_vec());
        double zeta(0);
        zeta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, zeta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable zeta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 147;
        if (!(context__.contains_r("mu0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu0", "double", context__.to_vec());
        double mu0(0);
        mu0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(mu0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 149;
        if (!(context__.contains_r("c")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable c missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("c");
        pos__ = 0U;
        validate_non_negative_index("c", "N_region", N_region);
        context__.validate_dims("parameter initialization", "c", "double", context__.to_vec(N_region));
        std::vector<double> c(N_region, double(0));
        size_t c_k_0_max__ = N_region;
        for (size_t k_0__ = 0; k_0__ < c_k_0_max__; ++k_0__) {
            c[k_0__] = vals_r__[pos__++];
        }
        size_t c_i_0_max__ = N_region;
        for (size_t i_0__ = 0; i_0__ < c_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(c[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable c: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 150;
        if (!(context__.contains_r("ct")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ct missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ct");
        pos__ = 0U;
        validate_non_negative_index("ct", "N_t", N_t);
        context__.validate_dims("parameter initialization", "ct", "double", context__.to_vec(N_t));
        std::vector<double> ct(N_t, double(0));
        size_t ct_k_0_max__ = N_t;
        for (size_t k_0__ = 0; k_0__ < ct_k_0_max__; ++k_0__) {
            ct[k_0__] = vals_r__[pos__++];
        }
        size_t ct_i_0_max__ = N_t;
        for (size_t i_0__ = 0; i_0__ < ct_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(ct[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ct: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 144;
            std::vector<local_scalar_t__> logp;
            size_t logp_d_0_max__ = N_distributed;
            logp.reserve(logp_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < logp_d_0_max__; ++d_0__) {
                if (jacobian__)
                    logp.push_back(in__.scalar_constrain(lp__));
                else
                    logp.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 145;
            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0, lp__);
            else
                sigma = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 146;
            local_scalar_t__ zeta;
            (void) zeta;  // dummy to suppress unused var warning
            if (jacobian__)
                zeta = in__.scalar_lb_constrain(0, lp__);
            else
                zeta = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 147;
            local_scalar_t__ mu0;
            (void) mu0;  // dummy to suppress unused var warning
            if (jacobian__)
                mu0 = in__.scalar_constrain(lp__);
            else
                mu0 = in__.scalar_constrain();
            current_statement_begin__ = 149;
            std::vector<local_scalar_t__> c;
            size_t c_d_0_max__ = N_region;
            c.reserve(c_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < c_d_0_max__; ++d_0__) {
                if (jacobian__)
                    c.push_back(in__.scalar_constrain(lp__));
                else
                    c.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 150;
            std::vector<local_scalar_t__> ct;
            size_t ct_d_0_max__ = N_t;
            ct.reserve(ct_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < ct_d_0_max__; ++d_0__) {
                if (jacobian__)
                    ct.push_back(in__.scalar_constrain(lp__));
                else
                    ct.push_back(in__.scalar_constrain());
            }
            // transformed parameters
            current_statement_begin__ = 158;
            validate_non_negative_index("p", "N_distributed", N_distributed);
            std::vector<local_scalar_t__> p(N_distributed, local_scalar_t__(0));
            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 160;
            stan::math::assign(p, inv_logit(logp));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 158;
            size_t p_k_0_max__ = N_distributed;
            for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(p[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: p" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable p: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 167;
            lp_accum__.add(normal_log<propto__>(mu0, mu0_mu, mu0_sigma));
            current_statement_begin__ = 168;
            lp_accum__.add(normal_log<propto__>(sigma, sigma_mu, sigma_sigma));
            current_statement_begin__ = 171;
            lp_accum__.add(normal_log<propto__>(c, 0, 1));
            current_statement_begin__ = 172;
            lp_accum__.add(normal_log<propto__>(get_base1(ct, 1, "ct", 1), 0, 1));
            current_statement_begin__ = 173;
            lp_accum__.add(normal_log<propto__>(zeta, 0, 1));
            current_statement_begin__ = 175;
            if (as_bool(logical_eq(rw_type, 1))) {
                current_statement_begin__ = 176;
                for (int i = 2; i <= N_t; ++i) {
                    current_statement_begin__ = 177;
                    lp_accum__.add(normal_log<propto__>(get_base1(ct, i, "ct", 1), get_base1(ct, (i - 1), "ct", 1), zeta));
                }
            } else {
                current_statement_begin__ = 181;
                for (int i = 1; i <= (N_t - 2); ++i) {
                    current_statement_begin__ = 182;
                    lp_accum__.add(normal_log<propto__>(((get_base1(ct, i, "ct", 1) - (2 * get_base1(ct, (i + 1), "ct", 1))) + get_base1(ct, (i + 2), "ct", 1)), 0, zeta));
                }
            }
            current_statement_begin__ = 187;
            lp_accum__.add(normal_log<propto__>(logp, add(add(mu0, to_vector(stan::model::rvalue(c, stan::model::cons_list(stan::model::index_multi(regions), stan::model::nil_index_list()), "c"))), to_vector(stan::model::rvalue(ct, stan::model::cons_list(stan::model::index_multi(times), stan::model::nil_index_list()), "ct"))), sigma));
            current_statement_begin__ = 191;
            if (as_bool(logical_eq(run_estimation, 1))) {
                current_statement_begin__ = 192;
                lp_accum__.add(binomial_log<propto__>(Reported_Used, Reported_Distributed, p));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("logp");
        names__.push_back("sigma");
        names__.push_back("zeta");
        names__.push_back("mu0");
        names__.push_back("c");
        names__.push_back("ct");
        names__.push_back("p");
        names__.push_back("sim_used");
        names__.push_back("Distributed");
        names__.push_back("Distributed2D");
        names__.push_back("sim_p");
        names__.push_back("sim_p2D");
        names__.push_back("sim_actual_used");
        names__.push_back("region_distributed");
        names__.push_back("convolve_region_distributed");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(N_distributed);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_region);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_distributed);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_region);
        dims__.push_back(N_t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_region);
        dims__.push_back(N_t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_t);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_distribution_covariate_model_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> logp;
        size_t logp_d_0_max__ = N_distributed;
        logp.reserve(logp_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < logp_d_0_max__; ++d_0__) {
            logp.push_back(in__.scalar_constrain());
        }
        size_t logp_k_0_max__ = N_distributed;
        for (size_t k_0__ = 0; k_0__ < logp_k_0_max__; ++k_0__) {
            vars__.push_back(logp[k_0__]);
        }
        double sigma = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma);
        double zeta = in__.scalar_lb_constrain(0);
        vars__.push_back(zeta);
        double mu0 = in__.scalar_constrain();
        vars__.push_back(mu0);
        std::vector<double> c;
        size_t c_d_0_max__ = N_region;
        c.reserve(c_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < c_d_0_max__; ++d_0__) {
            c.push_back(in__.scalar_constrain());
        }
        size_t c_k_0_max__ = N_region;
        for (size_t k_0__ = 0; k_0__ < c_k_0_max__; ++k_0__) {
            vars__.push_back(c[k_0__]);
        }
        std::vector<double> ct;
        size_t ct_d_0_max__ = N_t;
        ct.reserve(ct_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < ct_d_0_max__; ++d_0__) {
            ct.push_back(in__.scalar_constrain());
        }
        size_t ct_k_0_max__ = N_t;
        for (size_t k_0__ = 0; k_0__ < ct_k_0_max__; ++k_0__) {
            vars__.push_back(ct[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 158;
            validate_non_negative_index("p", "N_distributed", N_distributed);
            std::vector<double> p(N_distributed, double(0));
            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 160;
            stan::math::assign(p, inv_logit(logp));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t p_k_0_max__ = N_distributed;
                for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                    vars__.push_back(p[k_0__]);
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 199;
            validate_non_negative_index("sim_used", "N", N);
            std::vector<int> sim_used(N, int(0));
            stan::math::fill(sim_used, std::numeric_limits<int>::min());
            current_statement_begin__ = 201;
            validate_non_negative_index("Distributed", "N", N);
            std::vector<int> Distributed(N, int(0));
            stan::math::fill(Distributed, std::numeric_limits<int>::min());
            current_statement_begin__ = 202;
            validate_non_negative_index("Distributed2D", "N_region", N_region);
            validate_non_negative_index("Distributed2D", "N_t", N_t);
            std::vector<std::vector<int> > Distributed2D(N_region, std::vector<int>(N_t, int(0)));
            stan::math::fill(Distributed2D, std::numeric_limits<int>::min());
            current_statement_begin__ = 203;
            validate_non_negative_index("sim_p", "N", N);
            std::vector<double> sim_p(N, double(0));
            stan::math::initialize(sim_p, DUMMY_VAR__);
            stan::math::fill(sim_p, DUMMY_VAR__);
            current_statement_begin__ = 204;
            validate_non_negative_index("sim_p2D", "N_region", N_region);
            validate_non_negative_index("sim_p2D", "N_t", N_t);
            std::vector<std::vector<double> > sim_p2D(N_region, std::vector<double>(N_t, double(0)));
            stan::math::initialize(sim_p2D, DUMMY_VAR__);
            stan::math::fill(sim_p2D, DUMMY_VAR__);
            current_statement_begin__ = 206;
            validate_non_negative_index("sim_actual_used", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> sim_actual_used(N);
            stan::math::initialize(sim_actual_used, DUMMY_VAR__);
            stan::math::fill(sim_actual_used, DUMMY_VAR__);
            current_statement_begin__ = 208;
            validate_non_negative_index("region_distributed", "N_t", N_t);
            std::vector<int> region_distributed(N_t, int(0));
            stan::math::fill(region_distributed, std::numeric_limits<int>::min());
            current_statement_begin__ = 209;
            validate_non_negative_index("convolve_region_distributed", "N_t", N_t);
            std::vector<int> convolve_region_distributed(N_t, int(0));
            stan::math::fill(convolve_region_distributed, std::numeric_limits<int>::min());
            // generated quantities statements
            current_statement_begin__ = 212;
            for (int i = 1; i <= N_region; ++i) {
                current_statement_begin__ = 213;
                stan::math::assign(region_distributed, stan::model::rvalue(Orders2D, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "Orders2D"));
                current_statement_begin__ = 219;
                for (int s = 1; s <= N_t; ++s) {
                    current_statement_begin__ = 220;
                    stan::model::assign(convolve_region_distributed, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                sum(binomial_rng(stan::model::rvalue(region_distributed, stan::model::cons_list(stan::model::index_min_max(std::max(1, ((s - max_delays) + 1)), s), stan::model::nil_index_list()), "region_distributed"), tail(reverse_distribute_pmf, std::min(max_delays, s)), base_rng__)), 
                                "assigning variable convolve_region_distributed");
                    current_statement_begin__ = 222;
                    stan::model::assign(sim_p2D, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list())), 
                                normal_rng(((mu0 + get_base1(c, i, "c", 1)) + get_base1(ct, s, "ct", 1)), sigma, base_rng__), 
                                "assigning variable sim_p2D");
                }
                current_statement_begin__ = 225;
                stan::model::assign(Distributed2D, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                            convolve_region_distributed, 
                            "assigning variable Distributed2D");
            }
            current_statement_begin__ = 233;
            stan::math::assign(Distributed, to_array_1d(Distributed2D));
            current_statement_begin__ = 234;
            stan::math::assign(sim_p, inv_logit(to_array_1d(sim_p2D)));
            current_statement_begin__ = 236;
            stan::math::assign(sim_used, binomial_rng(Distributed, sim_p, base_rng__));
            current_statement_begin__ = 240;
            for (int i = 1; i <= N_region; ++i) {
                current_statement_begin__ = 241;
                stan::model::assign(sim_actual_used, 
                            stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * N_t)), (i * N_t)), stan::model::nil_index_list()), 
                            mdivide_left_tri_low(reporting_delay_matrix, segment(to_vector(sim_used), (1 + ((i - 1) * N_t)), N_t)), 
                            "assigning variable sim_actual_used");
            }
            // validate, write generated quantities
            current_statement_begin__ = 199;
            size_t sim_used_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < sim_used_k_0_max__; ++k_0__) {
                vars__.push_back(sim_used[k_0__]);
            }
            current_statement_begin__ = 201;
            size_t Distributed_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < Distributed_k_0_max__; ++k_0__) {
                vars__.push_back(Distributed[k_0__]);
            }
            current_statement_begin__ = 202;
            size_t Distributed2D_k_0_max__ = N_region;
            size_t Distributed2D_k_1_max__ = N_t;
            for (size_t k_1__ = 0; k_1__ < Distributed2D_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < Distributed2D_k_0_max__; ++k_0__) {
                    vars__.push_back(Distributed2D[k_0__][k_1__]);
                }
            }
            current_statement_begin__ = 203;
            size_t sim_p_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < sim_p_k_0_max__; ++k_0__) {
                vars__.push_back(sim_p[k_0__]);
            }
            current_statement_begin__ = 204;
            size_t sim_p2D_k_0_max__ = N_region;
            size_t sim_p2D_k_1_max__ = N_t;
            for (size_t k_1__ = 0; k_1__ < sim_p2D_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sim_p2D_k_0_max__; ++k_0__) {
                    vars__.push_back(sim_p2D[k_0__][k_1__]);
                }
            }
            current_statement_begin__ = 206;
            size_t sim_actual_used_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < sim_actual_used_j_1_max__; ++j_1__) {
                vars__.push_back(sim_actual_used(j_1__));
            }
            current_statement_begin__ = 208;
            size_t region_distributed_k_0_max__ = N_t;
            for (size_t k_0__ = 0; k_0__ < region_distributed_k_0_max__; ++k_0__) {
                vars__.push_back(region_distributed[k_0__]);
            }
            current_statement_begin__ = 209;
            size_t convolve_region_distributed_k_0_max__ = N_t;
            for (size_t k_0__ = 0; k_0__ < convolve_region_distributed_k_0_max__; ++k_0__) {
                vars__.push_back(convolve_region_distributed[k_0__]);
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_distribution_covariate_model";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t logp_k_0_max__ = N_distributed;
        for (size_t k_0__ = 0; k_0__ < logp_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logp" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "zeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu0";
        param_names__.push_back(param_name_stream__.str());
        size_t c_k_0_max__ = N_region;
        for (size_t k_0__ = 0; k_0__ < c_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "c" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ct_k_0_max__ = N_t;
        for (size_t k_0__ = 0; k_0__ < ct_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ct" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t p_k_0_max__ = N_distributed;
            for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t sim_used_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < sim_used_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_used" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Distributed_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < Distributed_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Distributed" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Distributed2D_k_0_max__ = N_region;
        size_t Distributed2D_k_1_max__ = N_t;
        for (size_t k_1__ = 0; k_1__ < Distributed2D_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < Distributed2D_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Distributed2D" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sim_p_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < sim_p_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_p" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sim_p2D_k_0_max__ = N_region;
        size_t sim_p2D_k_1_max__ = N_t;
        for (size_t k_1__ = 0; k_1__ < sim_p2D_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < sim_p2D_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sim_p2D" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sim_actual_used_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sim_actual_used_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_actual_used" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t region_distributed_k_0_max__ = N_t;
        for (size_t k_0__ = 0; k_0__ < region_distributed_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "region_distributed" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t convolve_region_distributed_k_0_max__ = N_t;
        for (size_t k_0__ = 0; k_0__ < convolve_region_distributed_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "convolve_region_distributed" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t logp_k_0_max__ = N_distributed;
        for (size_t k_0__ = 0; k_0__ < logp_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logp" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "zeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu0";
        param_names__.push_back(param_name_stream__.str());
        size_t c_k_0_max__ = N_region;
        for (size_t k_0__ = 0; k_0__ < c_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "c" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ct_k_0_max__ = N_t;
        for (size_t k_0__ = 0; k_0__ < ct_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ct" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t p_k_0_max__ = N_distributed;
            for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t sim_used_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < sim_used_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_used" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Distributed_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < Distributed_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Distributed" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Distributed2D_k_0_max__ = N_region;
        size_t Distributed2D_k_1_max__ = N_t;
        for (size_t k_1__ = 0; k_1__ < Distributed2D_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < Distributed2D_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Distributed2D" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sim_p_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < sim_p_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_p" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sim_p2D_k_0_max__ = N_region;
        size_t sim_p2D_k_1_max__ = N_t;
        for (size_t k_1__ = 0; k_1__ < sim_p2D_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < sim_p2D_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sim_p2D" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sim_actual_used_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sim_actual_used_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_actual_used" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t region_distributed_k_0_max__ = N_t;
        for (size_t k_0__ = 0; k_0__ < region_distributed_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "region_distributed" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t convolve_region_distributed_k_0_max__ = N_t;
        for (size_t k_0__ = 0; k_0__ < convolve_region_distributed_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "convolve_region_distributed" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_distribution_covariate_model_namespace::model_distribution_covariate_model stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
