% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{species_richness}
\alias{species_richness}
\alias{species_richness_}
\title{Species Richness}
\usage{
species_richness(.data = NULL, taxon, count = NULL)

species_richness_(.data = NULL, taxon, count = NULL)
}
\arguments{
\item{.data}{data in a \code{data.frame}, \code{tibble}, 
\code{data.table}, database etc.}

\item{taxon}{taxa names (\code{character})}

\item{count}{number of individuals for each taxon (\code{numeric})}
}
\value{
species richness (\code{integer} vector of length 1)
}
\description{
Species richness (\eqn{S}{S}) is defined as the number of taxa 
(lowest identification level possible) per sampling unit 
(data pool or box core sample).
}
\section{Functions}{
\itemize{
\item \code{species_richness_()}: version suitable for calling from a function
(see package \pkg{lazyeval}).

}}
\examples{
 species_richness(
     taxon = c("Euspira pulchella", "Nephtys cirrosa"), 
     count = c(4, 6)
 )
 
}
